/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.graphiti.handler;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDoubleClickContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.impl.CustomContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.tb.IContextButtonEntry;
import org.eclipse.graphiti.tb.IContextButtonPadData;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.graphiti.GraphitiLayerException;
import org.eclipse.reddeer.graphiti.api.ContextButton;
import org.eclipse.reddeer.graphiti.impl.contextbutton.internal.BasicContextButton;
import org.eclipse.reddeer.graphiti.lookup.DiagramEditorLookup;

public class GraphitiEditPartHandler {
    protected final Logger log = Logger.getLogger(this.getClass());
    private static GraphitiEditPartHandler instance;

    public static GraphitiEditPartHandler getInstance() {
        if (instance == null) {
            instance = new GraphitiEditPartHandler();
        }
        return instance;
    }

    public List<ContextButton> getContextButtons(EditPart editPart) {
        return this.getContextButtons(DiagramEditorLookup.getInstance().findDiagramEditor(), editPart);
    }

    private List<ContextButton> getContextButtons(final DiagramEditor diagramEditor, final EditPart editPart) {
        return (List)Display.syncExec((ResultRunnable)new ResultRunnable<List<ContextButton>>(){

            public List<ContextButton> run() {
                ArrayList entries = new ArrayList();
                IToolBehaviorProvider[] tool = diagramEditor.getDiagramTypeProvider().getAvailableToolBehaviorProviders();
                int i = 0;
                while (i < tool.length) {
                    PictogramContext context = GraphitiEditPartHandler.this.createPictogramContext(editPart);
                    IContextButtonPadData pad = tool[i].getContextButtonPad((IPictogramElementContext)context);
                    entries.addAll(pad.getDomainSpecificContextButtons());
                    entries.addAll(pad.getGenericContextButtons());
                    ++i;
                }
                ArrayList<ContextButton> contextButtonEntries = new ArrayList<ContextButton>();
                for (IContextButtonEntry entry : entries) {
                    BasicContextButton contextButtonEntry = new BasicContextButton(entry);
                    contextButtonEntries.add(contextButtonEntry);
                }
                return contextButtonEntries;
            }
        });
    }

    public void doubleClick(EditPart editPart) {
        this.doubleClick(DiagramEditorLookup.getInstance().findDiagramEditor(), editPart);
    }

    private void doubleClick(final DiagramEditor diagramEditor, final EditPart editPart) {
        List features = (List)Display.syncExec((ResultRunnable)new ResultRunnable<List<ICustomFeature>>(){

            public List<ICustomFeature> run() {
                ArrayList<ICustomFeature> features = new ArrayList<ICustomFeature>();
                IToolBehaviorProvider[] tool = diagramEditor.getDiagramTypeProvider().getAvailableToolBehaviorProviders();
                int i = 0;
                while (i < tool.length) {
                    PictogramContext context = GraphitiEditPartHandler.this.createPictogramContext(editPart);
                    ICustomFeature feature = tool[i].getDoubleClickFeature((IDoubleClickContext)context);
                    if (feature != null) {
                        features.add(feature);
                    }
                    ++i;
                }
                return features;
            }
        });
        if (features.isEmpty()) {
            throw new GraphitiLayerException("Cannot call double click");
        }
        for (final ICustomFeature feature : features) {
            Display.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    feature.execute((ICustomContext)GraphitiEditPartHandler.this.createPictogramContext(editPart));
                }
            });
        }
        Display.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    private PictogramContext createPictogramContext(EditPart part) {
        PictogramElement pe = null;
        try {
            Method method = part.getClass().getMethod("getPictogramElement", new Class[0]);
            Object obj = method.invoke((Object)part, new Object[0]);
            pe = (PictogramElement)obj;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create PictogramElementContext", e);
        }
        if (pe == null) {
            throw new RuntimeException("Cannot create PictogramElementContext, pe is null");
        }
        return new PictogramContext(pe);
    }

    private class PictogramContext
    extends CustomContext
    implements IPictogramElementContext,
    IDoubleClickContext {
        public PictogramContext(PictogramElement pictogramElement) {
            super(new PictogramElement[]{pictogramElement});
        }

        public PictogramElement getPictogramElement() {
            return this.getPictogramElements()[0];
        }
    }
}

