/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.terminals.core.launcher;

import java.util.EventObject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.services.ITerminals;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.terminals.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.terminals.core.interfaces.launcher.ITerminalsContextAwareListener;
import org.eclipse.tcf.te.tcf.terminals.core.launcher.TerminalsLauncher;
import org.eclipse.tcf.te.tcf.terminals.core.launcher.TerminalsStateChangeEvent;

public class TerminalsListener
implements ITerminals.TerminalsListener,
ITerminalsContextAwareListener {
    private final TerminalsLauncher parent;
    private ITerminals.TerminalContext context;
    private boolean exitedCalled = false;

    public TerminalsListener(TerminalsLauncher parent) {
        Assert.isNotNull((Object)parent);
        this.parent = parent;
    }

    protected final TerminalsLauncher getParent() {
        return this.parent;
    }

    public void dispose(ICallback callback) {
        if (!this.exitedCalled && this.context != null) {
            TerminalsStateChangeEvent event = new TerminalsStateChangeEvent(this.context, "lostCommunication", Boolean.FALSE, Boolean.TRUE, -1);
            EventManager.getInstance().fireEvent((EventObject)((Object)event));
        }
        if (callback != null) {
            callback.done((Object)this, Status.OK_STATUS);
        }
    }

    @Override
    public void setTerminalsContext(ITerminals.TerminalContext context) {
        Assert.isNotNull((Object)context);
        this.context = context;
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/terminalsListener")) {
            CoreBundleActivator.getTraceHandler().trace("Terminals context set to: id='" + context.getID() + "', PTY type='" + context.getPtyType() + "'", 0, "trace/terminalsListener", 1, this.getClass());
        }
    }

    @Override
    public ITerminals.TerminalContext getTerminalsContext() {
        return this.context;
    }

    public void exited(String terminalId, int exitCode) {
        ITerminals.TerminalContext context;
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/terminalsListener")) {
            CoreBundleActivator.getTraceHandler().trace("Terminals context terminated: id='" + terminalId + "', exitCode='" + exitCode + "'", 0, "trace/terminalsListener", 1, this.getClass());
        }
        if ((context = this.getTerminalsContext()) != null && terminalId != null && terminalId.equals(context.getID())) {
            this.exitedCalled = true;
            TerminalsStateChangeEvent event = this.createRemoteTerminalStateChangeEvent(context, exitCode);
            EventManager.getInstance().fireEvent((EventObject)((Object)event));
            this.getParent().dispose();
        }
    }

    protected TerminalsStateChangeEvent createRemoteTerminalStateChangeEvent(ITerminals.TerminalContext context, int exitCode) {
        Assert.isNotNull((Object)context);
        return new TerminalsStateChangeEvent(context, "terminated", Boolean.FALSE, Boolean.TRUE, exitCode);
    }

    public void winSizeChanged(String terminalId, int newWidth, int newHeight) {
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/terminalsListener")) {
            CoreBundleActivator.getTraceHandler().trace("Terminals context window size changed: id='" + terminalId + "', newWidth='" + newWidth + "', newHeight='" + newHeight + "'", 0, "trace/terminalsListener", 1, this.getClass());
        }
    }
}

