/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.notifications.delegates;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tcf.te.runtime.events.NotifyEvent;
import org.eclipse.tcf.te.ui.notifications.activator.UIPlugin;
import org.eclipse.tcf.te.ui.notifications.interfaces.IFormTextFactoryDelegate;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DefaultFormTextFactoryDelegate
implements IFormTextFactoryDelegate {
    @Override
    public void populateFormText(FormToolkit toolkit, FormText widget, NotifyEvent event) {
        Assert.isNotNull((Object)toolkit);
        Assert.isNotNull((Object)widget);
        Assert.isNotNull((Object)event);
        String titleText = event.getProperties().getStringProperty("titleText");
        String titleImageId = event.getProperties().getStringProperty("titleImageId");
        String description = event.getProperties().getStringProperty("descriptionText");
        if (titleText != null && description != null) {
            Image image;
            StringBuilder buffer = new StringBuilder();
            buffer.append("<form>");
            buffer.append("<p>");
            if (titleImageId != null && (image = this.getImage(titleImageId)) != null) {
                buffer.append("<img href=\"titleImage\"/> ");
                widget.setImage("titleImage", image);
            }
            buffer.append("<span color=\"header\" font=\"header\">");
            buffer.append(titleText);
            buffer.append("</span>");
            buffer.append("</p>");
            buffer.append("<p>");
            buffer.append("<span font=\"text\">");
            buffer.append(description);
            buffer.append("</span>");
            buffer.append("</p>");
            buffer.append("</form>");
            this.setFormTextColors(toolkit, widget);
            this.setFormTextFonts(toolkit, widget);
            widget.setText(buffer.toString(), true, false);
        }
    }

    protected void setFormTextColors(FormToolkit toolkit, FormText widget) {
        Assert.isNotNull((Object)toolkit);
        Assert.isNotNull((Object)widget);
        widget.setColor("header", toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
    }

    protected void setFormTextFonts(FormToolkit toolkit, FormText widget) {
        Assert.isNotNull((Object)toolkit);
        Assert.isNotNull((Object)widget);
        widget.setFont("header", JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        widget.setFont("text", JFaceResources.getTextFont());
    }

    protected Image getImage(String key) {
        return UIPlugin.getImage(key);
    }

    @Override
    public long getNotificationCloseDelay() {
        return -1L;
    }
}

