/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.model.SeriesModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ISeriesModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfCommonXAxisModel;
import org.eclipse.tracecompass.tmf.core.model.xy.IYModel;

public class TmfCommonXAxisModel
implements ITmfCommonXAxisModel {
    @SerializedName(value="title")
    private final String fTitle;
    @SerializedName(value="xValues")
    private final long[] fXValues;
    @SerializedName(value="series")
    private final Collection<IYModel> fYSeries;
    private final transient Collection<ISeriesModel> fSeries;

    @Deprecated
    public TmfCommonXAxisModel(String title, long[] xValues, Map<String, IYModel> ySeries) {
        this.fTitle = title;
        this.fXValues = Arrays.copyOf(xValues, xValues.length);
        this.fYSeries = ImmutableList.copyOf(ySeries.values());
        ArrayList<SeriesModel> series = new ArrayList<SeriesModel>();
        for (IYModel model : this.fYSeries) {
            series.add(new SeriesModel(model.getId(), model.getName(), this.fXValues, model.getData()));
        }
        this.fSeries = ImmutableList.copyOf(series);
    }

    public TmfCommonXAxisModel(String title, long[] xValues, Collection<IYModel> ySeries) {
        this.fTitle = title;
        this.fXValues = Arrays.copyOf(xValues, xValues.length);
        this.fYSeries = ImmutableList.copyOf(ySeries);
        ArrayList<SeriesModel> series = new ArrayList<SeriesModel>();
        for (IYModel model : this.fYSeries) {
            series.add(new SeriesModel(model.getId(), model.getName(), this.fXValues, model.getData()));
        }
        this.fSeries = ImmutableList.copyOf(series);
    }

    @Override
    public long[] getXValues() {
        return this.fXValues;
    }

    @Override
    public @Nullable String getTitle() {
        return this.fTitle;
    }

    @Override
    public boolean hasCommonXAxis() {
        return true;
    }

    @Override
    public @NonNull Collection<@NonNull ISeriesModel> getSeriesData() {
        return this.fSeries;
    }

    @Override
    public @NonNull Collection<@NonNull IYModel> getYSeriesData() {
        return this.fYSeries;
    }

    @Override
    @Deprecated
    public @NonNull Map<String, IYModel> getYData() {
        return Maps.uniqueIndex(this.fYSeries, series -> series.getName());
    }

    @Override
    @Deprecated
    public Map<String, ISeriesModel> getData() {
        return Maps.uniqueIndex(this.fSeries, series -> series.getName());
    }
}

