/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.matcher.integration;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.viatra.query.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ILocalSearchAdapter;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.AbstractLocalSearchResultProvider;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.LocalSearchHints;
import org.eclipse.viatra.query.runtime.localsearch.plan.IPlanDescriptor;
import org.eclipse.viatra.query.runtime.localsearch.plan.IPlanProvider;
import org.eclipse.viatra.query.runtime.localsearch.plan.SimplePlanProvider;
import org.eclipse.viatra.query.runtime.matchers.backend.IMatcherCapability;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackend;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackendHintProvider;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryResultProvider;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.backend.ResultProviderRequestor;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryBackendContext;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.psystem.analysis.QueryAnalyzer;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.ICache;
import org.eclipse.viatra.query.runtime.matchers.util.PurgableCache;

public abstract class LocalSearchBackend
implements IQueryBackend {
    IQueryBackendContext context;
    IPlanProvider planProvider;
    private final Set<ILocalSearchAdapter> adapters = new HashSet<ILocalSearchAdapter>();
    private final PurgableCache generalCache;
    private final Map<PQuery, List<AbstractLocalSearchResultProvider>> resultProviderCache = CollectionsFactory.createMap();

    public LocalSearchBackend(IQueryBackendContext context) {
        this.context = context;
        this.generalCache = new PurgableCache();
        this.planProvider = new SimplePlanProvider(context.getLogger());
    }

    public void flushUpdates() {
    }

    public IQueryResultProvider getResultProvider(PQuery query) {
        return this.getResultProvider(query, null);
    }

    public IQueryResultProvider getResultProvider(PQuery query, QueryEvaluationHint hints) {
        QueryEvaluationHint callHints = this.getHintProvider().getQueryEvaluationHint(query).overrideBy(hints);
        IMatcherCapability requestedCapability = this.context.getRequiredMatcherCapability(query, callHints);
        for (AbstractLocalSearchResultProvider existingResultProvider : this.resultProviderCache.getOrDefault(query, Collections.emptyList())) {
            if (!requestedCapability.canBeSubstitute(existingResultProvider.getCapabilites())) continue;
            return existingResultProvider;
        }
        AbstractLocalSearchResultProvider resultProvider = this.initializeResultProvider(query, hints);
        this.resultProviderCache.computeIfAbsent(query, k -> new ArrayList()).add(resultProvider);
        resultProvider.prepare();
        return resultProvider;
    }

    public ResultProviderRequestor getResultProviderRequestor(PQuery query, QueryEvaluationHint userHints) {
        QueryEvaluationHint hintOnQuery = this.context.getHintProvider().getQueryEvaluationHint(query).overrideBy(userHints);
        LocalSearchHints defaultsApplied = LocalSearchHints.getDefaultOverriddenBy(hintOnQuery);
        return new ResultProviderRequestor((IQueryBackend)this, this.context.getResultProviderAccess(), this.context.getHintProvider(), defaultsApplied.getCallDelegationStrategy(), userHints, null);
    }

    protected abstract AbstractLocalSearchResultProvider initializeResultProvider(PQuery var1, QueryEvaluationHint var2);

    public void dispose() {
        this.resultProviderCache.clear();
        this.generalCache.purge();
    }

    public boolean isCaching() {
        return false;
    }

    public AbstractLocalSearchResultProvider peekExistingResultProvider(PQuery query) {
        return this.resultProviderCache.getOrDefault(query, Collections.emptyList()).stream().findAny().orElse(null);
    }

    public IQueryRuntimeContext getRuntimeContext() {
        return this.context.getRuntimeContext();
    }

    public QueryAnalyzer getQueryAnalyzer() {
        return this.context.getQueryAnalyzer();
    }

    public IQueryBackendHintProvider getHintProvider() {
        return this.context.getHintProvider();
    }

    public void addAdapter(ILocalSearchAdapter adapter) {
        this.adapters.add(adapter);
    }

    public void removeAdapter(ILocalSearchAdapter adapter) {
        this.adapters.remove(adapter);
    }

    public List<ILocalSearchAdapter> getAdapters() {
        return new ArrayList<ILocalSearchAdapter>(this.adapters);
    }

    public IQueryBackendContext getBackendContext() {
        return this.context;
    }

    public ICache getCache() {
        return this.generalCache;
    }

    public void recomputePlans(PQuery ... queries) {
        this.recomputePlans(Arrays.stream(queries).flatMap(query -> this.resultProviderCache.getOrDefault(query, Collections.emptyList()).stream()));
    }

    public void recomputePlans(Collection<PQuery> queries) {
        this.recomputePlans(queries.stream().flatMap(query -> this.resultProviderCache.getOrDefault(query, Collections.emptyList()).stream()));
    }

    public void recomputePlans() {
        this.recomputePlans(this.resultProviderCache.values().stream().flatMap(Collection::stream));
    }

    private void recomputePlans(Stream<AbstractLocalSearchResultProvider> resultProviders) {
        try {
            this.context.getRuntimeContext().coalesceTraversals(() -> {
                resultProviders.forEach(resultProvider -> {
                    resultProvider.forgetAllPlans();
                    resultProvider.prepare();
                });
                return null;
            });
        }
        catch (InvocationTargetException e) {
            throw new LocalSearchException("Error while rebuilding plans: " + e.getMessage(), e);
        }
    }

    public IPlanDescriptor getSearchPlan(PQuery query, Set<PParameter> adornment) {
        AbstractLocalSearchResultProvider resultProvider = this.peekExistingResultProvider(query);
        return resultProvider == null ? null : resultProvider.getSearchPlan(adornment);
    }
}

