/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.transformation.evm.api.event.ActivationState;
import org.eclipse.viatra.transformation.evm.api.event.EventType;

public class ActivationLifeCycle {
    private final Set<Transition> transitions = new LinkedHashSet<Transition>();
    private final Map<ActivationState, Map<EventType, Transition>> transitionMap = new HashMap<ActivationState, Map<EventType, Transition>>();
    private final ActivationState inactiveState;

    protected ActivationLifeCycle(ActivationState inactiveState) {
        Preconditions.checkArgument((inactiveState != null ? 1 : 0) != 0, (String)"Inactive state cannot be null");
        this.inactiveState = inactiveState;
    }

    public ActivationState nextActivationState(ActivationState currentState, EventType event) {
        Objects.requireNonNull(currentState, "Cannot find next state for null current state");
        Objects.requireNonNull(event, "Cannot find next state for null event");
        return this.findTargetTransition(currentState, event).map(Transition::getTo).orElse(null);
    }

    public boolean addStateTransition(ActivationState from, EventType event, ActivationState to) {
        return this.addStateTransition(new Transition(from, event, to));
    }

    public boolean addStateTransition(Transition transition) {
        Objects.requireNonNull(transition);
        this.findConflictingTransition(transition).filter(conflicting -> Objects.equals(transition, conflicting)).ifPresent(t -> {
            this.transitions.remove(t);
            if (this.transitionMap.containsKey(((Transition)t).from)) {
                this.transitionMap.get(((Transition)t).from).remove(((Transition)t).event);
            }
        });
        if (this.transitions.contains(transition)) {
            return false;
        }
        this.transitionMap.computeIfAbsent(transition.from, tr -> new HashMap()).put(transition.event, transition);
        return this.transitions.add(transition);
    }

    public boolean containsFrom(ActivationState state) {
        return this.transitionMap.containsKey(state) && !this.transitionMap.get(state).isEmpty();
    }

    public boolean containsTo(ActivationState state) {
        return this.transitions.stream().anyMatch(tr -> Objects.equals(((Transition)tr).to, state));
    }

    public static ActivationLifeCycle copyOf(ActivationLifeCycle lifeCycle) {
        Objects.requireNonNull(lifeCycle, "Null life cycle cannot be copied!");
        ActivationLifeCycle lc = new ActivationLifeCycle(lifeCycle.inactiveState);
        lifeCycle.transitions.forEach(lc::addStateTransition);
        return lc;
    }

    public static ActivationLifeCycle create(ActivationState inactiveState) {
        return new ActivationLifeCycle(inactiveState);
    }

    public Set<Transition> getStateTransitions() {
        return new HashSet<Transition>(this.transitions);
    }

    public ActivationState getInactiveState() {
        return this.inactiveState;
    }

    public String toString() {
        return String.format("%s{transitions=%s}", this.getClass().getName(), this.transitions.stream().map(Object::toString).collect(Collectors.joining(", ")));
    }

    private Optional<Transition> findConflictingTransition(Transition tr) {
        return this.findTargetTransition(tr.from, tr.event);
    }

    private Optional<Transition> findTargetTransition(ActivationState from, EventType event) {
        return Optional.ofNullable(this.transitionMap.get(from)).map(table -> (Transition)table.get(event));
    }

    public static class Transition {
        private final ActivationState from;
        private final EventType event;
        private final ActivationState to;

        public Transition(ActivationState from, EventType event, ActivationState to) {
            Objects.requireNonNull(from, "From state cannot be null!");
            Objects.requireNonNull(event, "Event cannot be null!");
            Objects.requireNonNull(to, "To state cannot be null!");
            this.from = from;
            this.event = event;
            this.to = to;
        }

        public ActivationState getFrom() {
            return this.from;
        }

        public EventType getEvent() {
            return this.event;
        }

        public ActivationState getTo() {
            return this.to;
        }

        public int hashCode() {
            return Objects.hash(this.from, this.event, this.to);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Transition other = (Transition)obj;
            return Objects.equals(this.from, other.from) && Objects.equals(this.event, other.event) && Objects.equals(this.to, other.to);
        }

        public String toString() {
            return "Transition " + this.from + " --(" + this.event + ")--> " + this.to;
        }
    }
}

