/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.api.event.adapter;

import java.util.Map;
import java.util.Objects;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.transformation.evm.api.RuleInstance;
import org.eclipse.viatra.transformation.evm.api.event.Event;
import org.eclipse.viatra.transformation.evm.api.event.EventFilter;
import org.eclipse.viatra.transformation.evm.api.event.EventHandler;
import org.eclipse.viatra.transformation.evm.api.event.EventSource;
import org.eclipse.viatra.transformation.evm.api.event.EventType;
import org.eclipse.viatra.transformation.evm.api.event.adapter.EventProcessorAdapter;

public abstract class EventHandlerAdapter<EventAtom>
implements EventHandler<EventAtom> {
    private final EventSource<EventAtom> source;
    private final EventFilter<? super EventAtom> filter;
    private final RuleInstance<EventAtom> instance;
    private Map<EventType, EventProcessorAdapter<EventAtom>> processors;

    protected EventHandlerAdapter(EventSource<EventAtom> source, EventFilter<? super EventAtom> filter, RuleInstance<EventAtom> instance) {
        Preconditions.checkArgument((source != null ? 1 : 0) != 0, (String)"Cannot create handler with null source");
        Preconditions.checkArgument((filter != null ? 1 : 0) != 0, (String)"Cannot create handler with null filter");
        Preconditions.checkArgument((instance != null ? 1 : 0) != 0, (String)"Cannot create handler with null instance");
        this.instance = instance;
        this.source = source;
        this.filter = filter;
    }

    protected void prepareEventHandler() {
        this.processors = Objects.requireNonNull(this.prepareEventProcessors(), "Prepared event processor map was null!");
        this.instance.setHandler(this);
    }

    protected abstract Map<EventType, EventProcessorAdapter<EventAtom>> prepareEventProcessors();

    @Override
    public void handleEvent(Event<EventAtom> event) {
        EventType eventType;
        EventAtom eventAtom = event.getEventAtom();
        if (this.filter.isProcessable(eventAtom) && this.processors.containsKey(eventType = event.getEventType())) {
            EventProcessorAdapter<EventAtom> processor = this.processors.get(eventType);
            processor.processEvent(event);
        }
    }

    @Override
    public EventSource<EventAtom> getSource() {
        return this.source;
    }

    @Override
    public EventFilter<? super EventAtom> getEventFilter() {
        return this.filter;
    }

    protected RuleInstance<EventAtom> getInstance() {
        return this.instance;
    }
}

