/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.layout;

import java.util.List;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildAddBefore;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.broadcast.XmlObjectSetObjectAfter;
import org.eclipse.wb.internal.core.xml.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.xml.model.creation.IImplicitCreationSupport;
import org.eclipse.wb.internal.xwt.model.layout.LayoutInfo;
import org.eclipse.wb.internal.xwt.model.widgets.CompositeInfo;

public final class ImplicitLayoutCreationSupport
extends CreationSupport
implements IImplicitCreationSupport {
    private final CompositeInfo m_composite;
    private final Object m_objectListener1 = new ObjectInfoChildAddBefore(){

        public void invoke(ObjectInfo parent, ObjectInfo child, ObjectInfo[] nextChild) throws Exception {
            if (ImplicitLayoutCreationSupport.this.isAddLayout(parent, child) && parent.getChildren().contains(ImplicitLayoutCreationSupport.this.m_object)) {
                if (nextChild[0] == ImplicitLayoutCreationSupport.this.m_object) {
                    nextChild[0] = (ObjectInfo)GenericsUtils.getNextOrNull((List)parent.getChildren(), (Object)ImplicitLayoutCreationSupport.this.m_object);
                }
                parent.removeChild((ObjectInfo)ImplicitLayoutCreationSupport.this.m_object);
            }
        }
    };
    private final Object m_objectListener2 = new ObjectEventListener(){

        public void childRemoveAfter(ObjectInfo parent, ObjectInfo child) throws Exception {
            if (ImplicitLayoutCreationSupport.this.canAddImplicitLayout() && ImplicitLayoutCreationSupport.this.isAddLayout(parent, child)) {
                parent.addChild((ObjectInfo)ImplicitLayoutCreationSupport.this.m_object);
            }
        }
    };
    private final Object m_objectListener3 = new XmlObjectSetObjectAfter(){

        public void invoke(XmlObjectInfo target, Object o) throws Exception {
            if (target == ImplicitLayoutCreationSupport.this.m_composite) {
                Layout layout = ImplicitLayoutCreationSupport.this.m_composite.getComposite().getLayout();
                ImplicitLayoutCreationSupport.this.m_object.setObject((Object)layout);
            }
        }
    };

    public ImplicitLayoutCreationSupport(CompositeInfo composite) {
        this.m_composite = composite;
    }

    public String toString() {
        Class layoutClass = this.m_object.getDescription().getComponentClass();
        if (layoutClass == null) {
            return "implicit-layout: absolute";
        }
        return "implicit-layout: " + layoutClass.getName();
    }

    public DocumentElement getElement() {
        return this.m_composite.getCreationSupport().getElement();
    }

    public String getTitle() {
        return this.toString();
    }

    public void setObject(XmlObjectInfo object) throws Exception {
        super.setObject(object);
        this.m_composite.addBroadcastListener(this.m_objectListener1);
        this.m_composite.addBroadcastListener(this.m_objectListener2);
        this.m_composite.addBroadcastListener(this.m_objectListener3);
    }

    public void delete() throws Exception {
    }

    private boolean canAddImplicitLayout() {
        return this.m_composite.getArbitraryValue("We replace Layout, don't set implicit now.") != Boolean.TRUE;
    }

    private boolean isAddLayout(ObjectInfo parent, ObjectInfo child) {
        return parent == this.m_composite && child instanceof LayoutInfo && child != this.m_object;
    }
}

