export * from 'vscode-jsonrpc';
export * from 'vscode-languageserver-types';
export * from './messages';
export * from './protocol';
export { ProtocolConnection, createProtocolConnection } from './connection';
import * as st from './protocol.semanticTokens.proposed';
export declare namespace Proposed {
    const SemanticTokenTypes: typeof st.SemanticTokenTypes;
    const SemanticTokenModifiers: typeof st.SemanticTokenModifiers;
    type SemanticTokensLegend = st.SemanticTokensLegend;
    type SemanticTokens = st.SemanticTokens;
    const SemanticTokens: typeof st.SemanticTokens;
    type SemanticTokensPartialResult = st.SemanticTokensPartialResult;
    type SemanticTokensEdit = st.SemanticTokensEdit;
    type SemanticTokensEdits = st.SemanticTokensEdits;
    type SemanticTokensEditsPartialResult = st.SemanticTokensEditsPartialResult;
    type SemanticTokensClientCapabilities = st.SemanticTokensClientCapabilities;
    type SemanticTokensOptions = st.SemanticTokensOptions;
    type SemanticTokensRegistrationOptions = st.SemanticTokensRegistrationOptions;
    type SemanticTokensServerCapabilities = st.SemanticTokensServerCapabilities;
    type SemanticTokensParams = st.SemanticTokensParams;
    namespace SemanticTokensRequest {
        const method: "textDocument/semanticTokens";
        const type: import("./messages").ProtocolRequestType<st.SemanticTokensParams, st.SemanticTokens | null, st.SemanticTokensPartialResult, void, st.SemanticTokensRegistrationOptions>;
    }
    type SemanticTokensEditsParams = st.SemanticTokensEditsParams;
    namespace SemanticTokensEditsRequest {
        const method: "textDocument/semanticTokens/edits";
        const type: import("./messages").ProtocolRequestType<st.SemanticTokensEditsParams, st.SemanticTokens | st.SemanticTokensEdits | null, st.SemanticTokensPartialResult | st.SemanticTokensEditsPartialResult, void, st.SemanticTokensRegistrationOptions>;
    }
    type SemanticTokensRangeParams = st.SemanticTokensRangeParams;
    namespace SemanticTokensRangeRequest {
        const method: "textDocument/semanticTokens/range";
        const type: import("./messages").ProtocolRequestType<st.SemanticTokensRangeParams, st.SemanticTokens | null, st.SemanticTokensPartialResult, void, void>;
    }
}
