"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Red Hat. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
const testHelper_1 = require("./utils/testHelper");
const assert = require("assert");
const serviceSetup_1 = require("./utils/serviceSetup");
const languageService = testHelper_1.configureLanguageService(new serviceSetup_1.ServiceSetup().languageSettings);
suite('FindDefintion Tests', () => {
    describe('Jump to defintion', function () {
        function findLinks(content) {
            const testTextDocument = testHelper_1.setupTextDocument(content);
            return languageService.findLinks(testTextDocument);
        }
        it('Find source defintion', (done) => {
            const content = "definitions:\n  link:\n    type: string\ntype: object\nproperties:\n  uri:\n    $ref: '#/definitions/link'\n";
            const definitions = findLinks(content);
            definitions
                .then(function (results) {
                assert.equal(results.length, 1);
                assert.deepEqual(results[0].range, {
                    start: {
                        line: 6,
                        character: 11,
                    },
                    end: {
                        line: 6,
                        character: 29,
                    },
                });
                assert.deepEqual(results[0].target, 'file://~/Desktop/vscode-k8s/test.yaml#3,5');
            })
                .then(done, done);
        });
    });
});
//# sourceMappingURL=findLinks.test.js.map