/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumDebugPlugin;
import org.eclipse.wst.jsdt.chromium.debug.core.model.BreakpointSynchronizer;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ConnectedTargetData;
import org.eclipse.wst.jsdt.chromium.debug.core.model.DebugElementImpl;
import org.eclipse.wst.jsdt.chromium.debug.core.model.EvaluateContext;
import org.eclipse.wst.jsdt.chromium.debug.core.model.JavascriptVmEmbedder;
import org.eclipse.wst.jsdt.chromium.debug.core.model.SourceWrapSupport;
import org.eclipse.wst.jsdt.chromium.debug.core.model.TargetInitializeState;
import org.eclipse.wst.jsdt.chromium.debug.core.model.WorkspaceBridge;
import org.eclipse.wst.jsdt.chromium.util.Destructable;
import org.eclipse.wst.jsdt.chromium.util.DestructingGuard;

public class DebugTargetImpl
extends DebugElementImpl
implements IDebugTarget {
    static final IThread[] EMPTY_THREADS = new IThread[0];
    private final WorkspaceBridge.Factory workspaceBridgeFactory;
    private final SourceWrapSupport sourceWrapSupport;
    private final ILaunch launch;
    private final BreakpointSynchronizer.Direction presetSyncDirection;
    private volatile State currentState = new TargetInitializeState(this);

    public static boolean attach(DebugTargetImpl debugTargetImpl, JavascriptVmEmbedder.ConnectionToRemote remoteServer, DestructingGuard destructingGuard, Runnable attachCallback, IProgressMonitor monitor) throws CoreException {
        ConnectedTargetData connectedData;
        monitor.beginTask("", 2);
        JavascriptVmEmbedder.VmConnector connector = remoteServer.selectVm();
        if (connector == null) {
            return false;
        }
        monitor.worked(1);
        ListenerBlock listenerBlock = new ListenerBlock();
        try {
            ConnectedTargetData.TargetInnerState connectedState = ConnectedTargetData.create(debugTargetImpl, listenerBlock);
            connectedData = connectedState.getConnectedTargetData();
            final JavascriptVmEmbedder embedder = connector.attach(connectedData.getEmbedderListener(), connectedData.getDebugEventListener());
            Destructable embedderDestructor = new Destructable(){

                public void destruct() {
                    embedder.getJavascriptVm().detach();
                }
            };
            destructingGuard.addValue(embedderDestructor);
            connectedData.setVmEmbedder(embedder);
            debugTargetImpl.setInnerState(connectedState);
            connectedData.fireBecameConnectedEvents();
            listenerBlock.setProperlyInitialized();
        }
        finally {
            listenerBlock.unblock();
        }
        connectedData.initListeners();
        try {
            if (attachCallback != null) {
                attachCallback.run();
            }
        }
        catch (Exception e) {
            ChromiumDebugPlugin.log(e);
        }
        return true;
    }

    public DebugTargetImpl(ILaunch launch, WorkspaceBridge.Factory workspaceBridgeFactory, SourceWrapSupport sourceWrapSupport, BreakpointSynchronizer.Direction presetSyncDirection) {
        this.launch = launch;
        this.workspaceBridgeFactory = workspaceBridgeFactory;
        this.sourceWrapSupport = sourceWrapSupport;
        this.presetSyncDirection = presetSyncDirection;
    }

    public void fireTargetCreated() {
        DebugTargetImpl.fireDebugEvent(new DebugEvent((Object)this, 4));
    }

    void setInnerState(State state) {
        this.currentState = state;
    }

    ConnectedTargetData getConnectedDataOrNull() {
        return this.currentState.getConnectedTargetDataOrNull();
    }

    WorkspaceBridge.Factory getWorkspaceBridgeFactory() {
        return this.workspaceBridgeFactory;
    }

    @Override
    public DebugTargetImpl getDebugTarget() {
        return this;
    }

    @Override
    public ILaunch getLaunch() {
        return this.launch;
    }

    public boolean canTerminate() {
        return this.currentState.getTerminate().canTerminate();
    }

    public boolean isTerminated() {
        return this.currentState.getTerminate().isTerminated();
    }

    public void terminate() throws DebugException {
        this.currentState.getTerminate().terminate();
    }

    public boolean canResume() {
        return this.currentState.getSuspendResume().canResume();
    }

    public boolean canSuspend() {
        return this.currentState.getSuspendResume().canSuspend();
    }

    public boolean isSuspended() {
        return this.currentState.getSuspendResume().isSuspended();
    }

    public void resume() throws DebugException {
        this.currentState.getSuspendResume().resume();
    }

    public void suspend() throws DebugException {
        this.currentState.getSuspendResume().suspend();
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        this.currentState.getBreakpointListner().breakpointAdded(breakpoint);
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.currentState.getBreakpointListner().breakpointRemoved(breakpoint, delta);
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.currentState.getBreakpointListner().breakpointChanged(breakpoint, delta);
    }

    public boolean canDisconnect() {
        return this.currentState.getDisconnect().canDisconnect();
    }

    public void disconnect() throws DebugException {
        this.currentState.getDisconnect().disconnect();
    }

    public boolean isDisconnected() {
        return this.currentState.getDisconnect().isDisconnected();
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public IProcess getProcess() {
        return null;
    }

    public IThread[] getThreads() throws DebugException {
        return this.currentState.getThreads();
    }

    public boolean hasThreads() throws DebugException {
        return this.getThreads().length != 0;
    }

    public String getName() {
        return this.currentState.getName();
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return this.currentState.supportsBreakpoint(breakpoint);
    }

    public String getChromiumModelIdentifier() {
        return this.workspaceBridgeFactory.getDebugModelIdentifier();
    }

    public WorkspaceBridge.JsLabelProvider getLabelProvider() {
        return this.workspaceBridgeFactory.getLabelProvider();
    }

    public String getVmStatus() {
        return this.currentState.getVmStatus();
    }

    public ConnectedTargetData getConnectedOrNull() {
        return this.currentState.getConnectedTargetDataOrNull();
    }

    public SourceWrapSupport getSourceWrapSupport() {
        return this.sourceWrapSupport;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == EvaluateContext.class) {
            return this.currentState.getEvaluateContext();
        }
        if (adapter == ILaunch.class) {
            return this.launch;
        }
        return super.getAdapter(adapter);
    }

    public static List<ConnectedTargetData> getAllConnectedTargetDatas() {
        IDebugTarget[] array = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
        ArrayList<ConnectedTargetData> result = new ArrayList<ConnectedTargetData>(array.length);
        IDebugTarget[] iDebugTargetArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            DebugTargetImpl debugTargetImpl;
            ConnectedTargetData connectedData;
            IDebugTarget target = iDebugTargetArray[n2];
            if (target instanceof DebugTargetImpl && !target.getLaunch().isTerminated() && (connectedData = (debugTargetImpl = (DebugTargetImpl)target).getConnectedDataOrNull()) != null) {
                result.add(connectedData);
            }
            ++n2;
        }
        return result;
    }

    public static void fireDebugEvent(DebugEvent event) {
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        if (debugPlugin != null) {
            debugPlugin.fireDebugEventSet(new DebugEvent[]{event});
        }
    }

    BreakpointSynchronizer.Direction getPresetSyncDirection() {
        return this.presetSyncDirection;
    }

    static class ListenerBlock {
        private volatile boolean isBlocked = true;
        private volatile boolean hasBeenProperlyInitialized = false;
        private final Object monitor = new Object();

        ListenerBlock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitUntilReady() {
            if (this.isBlocked) {
                Object object = this.monitor;
                synchronized (object) {
                    while (this.isBlocked) {
                        try {
                            this.monitor.wait();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            if (!this.hasBeenProperlyInitialized) {
                throw new RuntimeException("DebugTarget has not been properly initialized");
            }
        }

        void setProperlyInitialized() {
            this.hasBeenProperlyInitialized = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unblock() {
            this.isBlocked = false;
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.notifyAll();
            }
        }
    }

    static abstract class State {
        State() {
        }

        abstract ITerminate getTerminate();

        abstract ISuspendResume getSuspendResume();

        abstract IDisconnect getDisconnect();

        abstract IBreakpointListener getBreakpointListner();

        abstract IThread[] getThreads() throws DebugException;

        abstract String getName();

        abstract String getVmStatus();

        abstract boolean supportsBreakpoint(IBreakpoint var1);

        abstract EvaluateContext getEvaluateContext();

        abstract ConnectedTargetData getConnectedTargetDataOrNull();
    }
}

