/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.core.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.xtend.shared.ui.Activator;
import org.eclipse.xtend.shared.ui.core.IXtendXpandProject;
import org.eclipse.xtend.shared.ui.core.IXtendXpandResource;

public class XtendAdapterFactory
implements IAdapterFactory {
    private static final Class[] ADAPTABLE_CLASSES = new Class[]{IXtendXpandProject.class, IXtendXpandResource.class, IProject.class, IResource.class, IStorage.class, IJavaProject.class};

    public Class[] getAdapterList() {
        return ADAPTABLE_CLASSES;
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof IResource) {
            return this.handleIResource((IResource)adaptableObject, adapterType);
        }
        if (adaptableObject instanceof IXtendXpandResource) {
            return this.handleIXtendXpandResource((IXtendXpandResource)adaptableObject, adapterType);
        }
        if (adaptableObject instanceof IXtendXpandProject) {
            return this.handleIXtendXpandProject((IXtendXpandProject)adaptableObject, adapterType);
        }
        return null;
    }

    private Object handleIResource(IResource res, Class adapterType) {
        IXtendXpandProject project = Activator.getExtXptModelManager().findProject(res);
        if (IXtendXpandProject.class.equals((Object)adapterType)) {
            return project;
        }
        if (IXtendXpandResource.class.equals((Object)adapterType)) {
            return project != null && res instanceof IStorage ? project.findXtendXpandResource((IStorage)res) : null;
        }
        return null;
    }

    private Object handleIXtendXpandResource(IXtendXpandResource res, Class adapterType) {
        if (IStorage.class.equals((Object)adapterType)) {
            return res.getUnderlyingStorage();
        }
        if (IResource.class.equals((Object)adapterType)) {
            IStorage st = res.getUnderlyingStorage();
            return st != null && st instanceof IResource ? st : null;
        }
        if (IProject.class.equals((Object)adapterType)) {
            IResource iResource = (IResource)(res.getUnderlyingStorage() != null && res.getUnderlyingStorage() instanceof IResource ? res.getUnderlyingStorage() : null);
            return iResource != null ? iResource.getProject() : null;
        }
        if (IXtendXpandProject.class.equals((Object)adapterType)) {
            IProject project = (IProject)this.handleIXtendXpandResource(res, IProject.class);
            return Activator.getExtXptModelManager().findProject((IResource)project);
        }
        return null;
    }

    private Object handleIXtendXpandProject(IXtendXpandProject project, Class adapterType) {
        if (IProject.class.equals((Object)adapterType)) {
            return project.getProject().getProject();
        }
        if (IJavaProject.class.equals((Object)adapterType)) {
            return project.getProject();
        }
        return null;
    }
}

