/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.execution;

import java.util.Optional;
import java.util.function.Function;
import org.junit.Ignore;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.vintage.engine.descriptor.RunnerTestDescriptor;
import org.junit.vintage.engine.descriptor.TestSourceProvider;
import org.junit.vintage.engine.descriptor.VintageTestDescriptor;
import org.junit.vintage.engine.execution.EventType;
import org.junit.vintage.engine.execution.TestRun;
import org.junit.vintage.engine.support.UniqueIdReader;
import org.junit.vintage.engine.support.UniqueIdStringifier;

class RunListenerAdapter
extends RunListener {
    private final TestRun testRun;
    private final EngineExecutionListener listener;
    private final TestSourceProvider testSourceProvider;
    private final Function<Description, String> uniqueIdExtractor;

    RunListenerAdapter(TestRun testRun, EngineExecutionListener listener, TestSourceProvider testSourceProvider) {
        this.testRun = testRun;
        this.listener = listener;
        this.testSourceProvider = testSourceProvider;
        this.uniqueIdExtractor = new UniqueIdReader().andThen(new UniqueIdStringifier());
    }

    public void testRunStarted(Description description) {
        if (description.isSuite() && description.getAnnotation(Ignore.class) == null) {
            this.fireExecutionStarted((TestDescriptor)this.testRun.getRunnerTestDescriptor(), EventType.REPORTED);
        }
    }

    public void testIgnored(Description description) {
        this.testIgnored(this.lookupOrRegisterNextTestDescriptor(description), this.determineReasonForIgnoredTest(description));
    }

    public void testStarted(Description description) {
        this.testStarted(this.lookupOrRegisterNextTestDescriptor(description), EventType.REPORTED);
    }

    public void testAssumptionFailure(Failure failure) {
        this.handleFailure(failure, TestExecutionResult::aborted);
    }

    public void testFailure(Failure failure) {
        this.handleFailure(failure, TestExecutionResult::failed);
    }

    public void testFinished(Description description) {
        this.testFinished(this.lookupOrRegisterCurrentTestDescriptor(description));
    }

    public void testRunFinished(Result result) {
        RunnerTestDescriptor runnerTestDescriptor = this.testRun.getRunnerTestDescriptor();
        if (this.testRun.isNotSkipped((TestDescriptor)runnerTestDescriptor)) {
            if (this.testRun.isNotStarted((TestDescriptor)runnerTestDescriptor)) {
                this.fireExecutionStarted((TestDescriptor)runnerTestDescriptor, EventType.SYNTHETIC);
            }
            this.testRun.getInProgressTestDescriptorsWithSyntheticStartEvents().stream().filter(this::canFinish).forEach(this::fireExecutionFinished);
            if (this.testRun.isNotFinished((TestDescriptor)runnerTestDescriptor)) {
                this.fireExecutionFinished((TestDescriptor)runnerTestDescriptor);
            }
        }
    }

    private TestDescriptor lookupOrRegisterNextTestDescriptor(Description description) {
        return this.lookupOrRegisterTestDescriptor(description, this.testRun::lookupNextTestDescriptor);
    }

    private TestDescriptor lookupOrRegisterCurrentTestDescriptor(Description description) {
        return this.lookupOrRegisterTestDescriptor(description, this.testRun::lookupCurrentTestDescriptor);
    }

    private TestDescriptor lookupOrRegisterTestDescriptor(Description description, Function<Description, Optional<VintageTestDescriptor>> lookup) {
        return (TestDescriptor)lookup.apply(description).orElseGet(() -> this.registerDynamicTestDescriptor(description, lookup));
    }

    private VintageTestDescriptor registerDynamicTestDescriptor(Description description, Function<Description, Optional<VintageTestDescriptor>> lookup) {
        TestDescriptor parent = this.findParent(description, lookup);
        UniqueId uniqueId = parent.getUniqueId().append("dynamic", this.uniqueIdExtractor.apply(description));
        VintageTestDescriptor dynamicDescriptor = new VintageTestDescriptor(uniqueId, description, this.testSourceProvider.findTestSource(description));
        parent.addChild((TestDescriptor)dynamicDescriptor);
        this.testRun.registerDynamicTest(dynamicDescriptor);
        this.dynamicTestRegistered((TestDescriptor)dynamicDescriptor);
        return dynamicDescriptor;
    }

    private TestDescriptor findParent(Description description, Function<Description, Optional<VintageTestDescriptor>> lookup) {
        return (TestDescriptor)Optional.ofNullable(description.getTestClass()).map(Description::createSuiteDescription).flatMap(lookup).orElseGet(this.testRun::getRunnerTestDescriptor);
    }

    private void handleFailure(Failure failure, Function<Throwable, TestExecutionResult> resultCreator) {
        this.handleFailure(failure, resultCreator, this.lookupOrRegisterCurrentTestDescriptor(failure.getDescription()));
    }

    private void handleFailure(Failure failure, Function<Throwable, TestExecutionResult> resultCreator, TestDescriptor testDescriptor) {
        TestExecutionResult result = resultCreator.apply(failure.getException());
        this.testRun.storeResult(testDescriptor, result);
        if (this.testRun.isNotStarted(testDescriptor)) {
            this.testStarted(testDescriptor, EventType.SYNTHETIC);
        }
        if (this.testRun.isNotFinished(testDescriptor) && testDescriptor.isContainer() && this.testRun.isDescendantOfRunnerTestDescriptor(testDescriptor)) {
            this.testFinished(testDescriptor);
        }
    }

    private void testIgnored(TestDescriptor testDescriptor, String reason) {
        this.fireExecutionFinishedForInProgressNonAncestorTestDescriptorsWithSyntheticStartEvents(testDescriptor);
        this.fireExecutionStartedIncludingUnstartedAncestors(testDescriptor.getParent());
        this.fireExecutionSkipped(testDescriptor, reason);
    }

    private String determineReasonForIgnoredTest(Description description) {
        Ignore ignoreAnnotation = (Ignore)description.getAnnotation(Ignore.class);
        return Optional.ofNullable(ignoreAnnotation).map(Ignore::value).orElse("<unknown>");
    }

    private void dynamicTestRegistered(TestDescriptor testDescriptor) {
        this.fireExecutionStartedIncludingUnstartedAncestors(testDescriptor.getParent());
        this.listener.dynamicTestRegistered(testDescriptor);
    }

    private void testStarted(TestDescriptor testDescriptor, EventType eventType) {
        this.fireExecutionFinishedForInProgressNonAncestorTestDescriptorsWithSyntheticStartEvents(testDescriptor);
        this.fireExecutionStartedIncludingUnstartedAncestors(testDescriptor.getParent());
        this.fireExecutionStarted(testDescriptor, eventType);
    }

    private void fireExecutionFinishedForInProgressNonAncestorTestDescriptorsWithSyntheticStartEvents(TestDescriptor testDescriptor) {
        this.testRun.getInProgressTestDescriptorsWithSyntheticStartEvents().stream().filter(it -> !this.isAncestor((TestDescriptor)it, testDescriptor) && this.canFinish((TestDescriptor)it)).forEach(this::fireExecutionFinished);
    }

    private boolean isAncestor(TestDescriptor candidate, TestDescriptor testDescriptor) {
        Optional parent = testDescriptor.getParent();
        if (!parent.isPresent()) {
            return false;
        }
        if (((TestDescriptor)parent.get()).equals(candidate)) {
            return true;
        }
        return this.isAncestor(candidate, (TestDescriptor)parent.get());
    }

    private void testFinished(TestDescriptor descriptor) {
        this.fireExecutionFinished(descriptor);
    }

    private void fireExecutionStartedIncludingUnstartedAncestors(Optional<TestDescriptor> parent) {
        if (parent.isPresent() && this.canStart(parent.get())) {
            this.fireExecutionStartedIncludingUnstartedAncestors(parent.get().getParent());
            this.fireExecutionStarted(parent.get(), EventType.SYNTHETIC);
        }
    }

    private boolean canStart(TestDescriptor testDescriptor) {
        return this.testRun.isNotStarted(testDescriptor) && (testDescriptor.equals((Object)this.testRun.getRunnerTestDescriptor()) || this.testRun.isDescendantOfRunnerTestDescriptor(testDescriptor));
    }

    private boolean canFinish(TestDescriptor testDescriptor) {
        return this.testRun.isNotFinished(testDescriptor) && this.testRun.isDescendantOfRunnerTestDescriptor(testDescriptor) && this.testRun.areAllFinishedOrSkipped(testDescriptor.getChildren());
    }

    private void fireExecutionSkipped(TestDescriptor testDescriptor, String reason) {
        this.testRun.markSkipped(testDescriptor);
        this.listener.executionSkipped(testDescriptor, reason);
    }

    private void fireExecutionStarted(TestDescriptor testDescriptor, EventType eventType) {
        this.testRun.markStarted(testDescriptor, eventType);
        this.listener.executionStarted(testDescriptor);
    }

    private void fireExecutionFinished(TestDescriptor testDescriptor) {
        this.testRun.markFinished(testDescriptor);
        this.listener.executionFinished(testDescriptor, this.testRun.getStoredResultOrSuccessful(testDescriptor));
    }
}

