/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb;

import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.IntKey;
import com.google.gwtorm.client.Key;
import com.google.gwtorm.client.StringKey;

public final class AccountGroup {
    @Column(id=1)
    protected NameKey name;
    @Column(id=2)
    protected Id groupId;
    @Column(id=3)
    protected Id ownerGroupId;
    @Column(id=4, length=0x7FFFFFFF, notNull=false)
    protected String description;
    @Column(id=5, length=8)
    protected String groupType;
    @Column(id=6, notNull=false)
    protected ExternalNameKey externalName;

    protected AccountGroup() {
    }

    public AccountGroup(NameKey newName, Id newId) {
        this.name = newName;
        this.ownerGroupId = this.groupId = newId;
        this.setType(Type.INTERNAL);
    }

    public Id getId() {
        return this.groupId;
    }

    public String getName() {
        return this.name.get();
    }

    public NameKey getNameKey() {
        return this.name;
    }

    public void setNameKey(NameKey nameKey) {
        this.name = nameKey;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String d) {
        this.description = d;
    }

    public Id getOwnerGroupId() {
        return this.ownerGroupId;
    }

    public void setOwnerGroupId(Id id) {
        this.ownerGroupId = id;
    }

    public Type getType() {
        return Type.valueOf(this.groupType);
    }

    public void setType(Type t) {
        this.groupType = t.name();
    }

    public ExternalNameKey getExternalNameKey() {
        return this.externalName;
    }

    public void setExternalNameKey(ExternalNameKey k) {
        this.externalName = k;
    }

    public static class ExternalNameKey
    extends StringKey<Key<?>> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        protected String name;

        protected ExternalNameKey() {
        }

        public ExternalNameKey(String n) {
            this.name = n;
        }

        public String get() {
            return this.name;
        }

        protected void set(String newValue) {
            this.name = newValue;
        }
    }

    public static class Id
    extends IntKey<Key<?>> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        protected int id;

        protected Id() {
        }

        public Id(int id) {
            this.id = id;
        }

        public int get() {
            return this.id;
        }

        protected void set(int newValue) {
            this.id = newValue;
        }

        public static Id parse(String str) {
            Id r = new Id();
            r.fromString(str);
            return r;
        }
    }

    public static class NameKey
    extends StringKey<Key<?>> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        protected String name;

        protected NameKey() {
        }

        public NameKey(String n) {
            this.name = n;
        }

        public String get() {
            return this.name;
        }

        protected void set(String newValue) {
            this.name = newValue;
        }
    }

    public static enum Type {
        SYSTEM,
        INTERNAL,
        LDAP;

    }
}

