/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.datepicker.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.i18n.client.constants.DateTimeConstants;
import java.util.Date;

public class CalendarUtil {
    static DateTimeConstants intlConstants;
    private static int firstDayOfWeekend;
    private static int lastDayOfWeekend;
    private static int startingDay;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void addDaysToDate(Date date, int days) {
        date.setDate(date.getDate() + days);
    }

    public static void addMonthsToDate(Date date, int months) {
        if (months != 0) {
            int month = date.getMonth();
            int year = date.getYear();
            int resultMonthCount = year * 12 + month + months;
            int resultYear = resultMonthCount / 12;
            int resultMonth = resultMonthCount - resultYear * 12;
            date.setMonth(resultMonth);
            date.setYear(resultYear);
        }
    }

    public static Date copyDate(Date date) {
        if (date == null) {
            return null;
        }
        Date newDate = new Date();
        newDate.setTime(date.getTime());
        return newDate;
    }

    public static int getDaysBetween(Date start, Date finish) {
        start = CalendarUtil.copyDate(start);
        CalendarUtil.resetTime(start);
        finish = CalendarUtil.copyDate(finish);
        CalendarUtil.resetTime(finish);
        long aTime = start.getTime();
        long bTime = finish.getTime();
        long adjust = 3600000L;
        adjust = bTime > aTime ? adjust : -adjust;
        return (int)((bTime - aTime + adjust) / 86400000L);
    }

    public static int getStartingDayOfWeek() {
        return startingDay;
    }

    public static boolean isSameDate(Date date0, Date date1) {
        if (!$assertionsDisabled && date0 == null) {
            throw new AssertionError((Object)"date0 cannot be null");
        }
        if (!$assertionsDisabled && date1 == null) {
            throw new AssertionError((Object)"date1 cannot be null");
        }
        return date0.getYear() == date1.getYear() && date0.getMonth() == date1.getMonth() && date0.getDate() == date1.getDate();
    }

    public static void setToFirstDayOfMonth(Date date) {
        CalendarUtil.resetTime(date);
        date.setDate(1);
    }

    static boolean isWeekend(int dayOfWeek) {
        return dayOfWeek == firstDayOfWeekend || dayOfWeek == lastDayOfWeekend;
    }

    private static void resetTime(Date date) {
        long msec = date.getTime();
        msec = msec / 1000L * 1000L;
        date.setTime(msec);
        date.setHours(12);
        date.setMinutes(0);
        date.setSeconds(0);
    }

    static {
        boolean bl = $assertionsDisabled = !CalendarUtil.class.desiredAssertionStatus();
        if (GWT.isClient()) {
            intlConstants = LocaleInfo.getCurrentLocale().getDateTimeConstants();
            firstDayOfWeekend = Integer.parseInt(intlConstants.weekendRange()[0]) - 1;
            lastDayOfWeekend = Integer.parseInt(intlConstants.weekendRange()[1]) - 1;
            startingDay = Integer.parseInt(intlConstants.firstDayOfTheWeek()) - 1;
        }
    }
}

