/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.commands;

import java.util.Iterator;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import org.eclipse.bpel.ui.IBPELUIConstants;
import org.eclipse.bpel.ui.commands.util.AutoUndoCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.wst.wsdl.WSDLFactory;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;

public class AddWSDLImportCommand
extends AutoUndoCommand {
    org.eclipse.wst.wsdl.Definition fDefinition;
    org.eclipse.wst.wsdl.Import fImport;

    public AddWSDLImportCommand(org.eclipse.wst.wsdl.Definition defn, Object object) {
        super((EObject)defn);
        this.setLabel(IBPELUIConstants.CMD_ADD_IMPORT);
        this.fDefinition = defn;
        this.fImport = this.createImport(object);
    }

    @Override
    public void doExecute() {
        if (this.fImport == null) {
            return;
        }
        if (!this.containsImport(this.fDefinition, this.fImport)) {
            this.fImport.setEnclosingDefinition(this.fDefinition);
            this.fDefinition.addImport((Import)this.fImport);
        }
    }

    org.eclipse.wst.wsdl.Import createImport(Object obj) {
        if (obj instanceof org.eclipse.wst.wsdl.Import) {
            return (org.eclipse.wst.wsdl.Import)obj;
        }
        org.eclipse.wst.wsdl.Import imp = null;
        EObject eObj = this.findImportableEntity((EObject)obj);
        if (eObj instanceof XSDSchema) {
            imp = this.createImportFrom((XSDSchema)eObj);
        } else if (eObj instanceof org.eclipse.wst.wsdl.Definition) {
            imp = this.createImportFrom((org.eclipse.wst.wsdl.Definition)eObj);
        }
        return imp;
    }

    EObject findImportableEntity(EObject eObj) {
        if (eObj instanceof XSDNamedComponent) {
            XSDNamedComponent xsdObj = (XSDNamedComponent)eObj;
            eObj = xsdObj.getSchema();
        }
        while (eObj != null) {
            if (eObj instanceof org.eclipse.wst.wsdl.Definition) {
                return eObj;
            }
            if (eObj instanceof XSDSchema && eObj.eContainer() == null) {
                return eObj;
            }
            eObj = eObj.eContainer();
        }
        return eObj;
    }

    org.eclipse.wst.wsdl.Import createImportFrom(XSDSchema schema) {
        org.eclipse.wst.wsdl.Import imp = WSDLFactory.eINSTANCE.createImport();
        String t = schema.getTargetNamespace();
        if (t != null) {
            imp.setNamespaceURI(t);
        }
        Resource resource = this.fDefinition.eResource();
        URI schemaURI = URI.createURI((String)schema.getSchemaLocation());
        imp.setLocationURI(schemaURI.deresolve(resource.getURI()).toString());
        imp.setDefinition((Definition)this.fDefinition);
        return imp;
    }

    org.eclipse.wst.wsdl.Import createImportFrom(org.eclipse.wst.wsdl.Definition defn) {
        org.eclipse.wst.wsdl.Import imp = WSDLFactory.eINSTANCE.createImport();
        String t = defn.getTargetNamespace();
        if (t != null) {
            imp.setNamespaceURI(t);
        }
        Resource resource = this.fDefinition.eResource();
        URI defnURI = defn.eResource().getURI();
        String importURI = defnURI.deresolve(resource.getURI()).toString();
        if (importURI == null) {
            importURI = defnURI.toString();
        }
        imp.setLocationURI(importURI);
        return imp;
    }

    boolean containsImport(org.eclipse.wst.wsdl.Definition defn, org.eclipse.wst.wsdl.Import imp) {
        EList imports = defn.getEImports();
        if (imports.contains((Object)imp)) {
            return true;
        }
        Iterator i = imports.iterator();
        boolean bExists = false;
        while (i.hasNext() && !bExists) {
            org.eclipse.wst.wsdl.Import n = (org.eclipse.wst.wsdl.Import)i.next();
            boolean bl = bExists = this.isEqual(n.getLocationURI(), imp.getLocationURI()) && this.isEqual(n.getNamespaceURI(), imp.getNamespaceURI());
        }
        return bExists;
    }

    boolean isEqual(String s1, String s2) {
        return s1 != null ? s1.equals(s2) : s2 == null;
    }
}

