/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.hovers;

import org.eclipse.bpel.ui.IHoverHelper;
import org.eclipse.bpel.ui.adapters.IAnnotatedElement;
import org.eclipse.bpel.ui.adapters.ILabeledElement;
import org.eclipse.core.resources.IMarker;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class DefaultHoverHelper
implements IHoverHelper {
    @Override
    public IFigure getHoverFigure(EObject modelObject) {
        String[] annotation;
        ILabeledElement e = this.getLabeledElement(modelObject);
        if (e == null) {
            return null;
        }
        String name = e.getLabel(modelObject);
        String type = e.getTypeLabel(modelObject);
        Figure panel = new Figure();
        panel.setLayoutManager((LayoutManager)new GridLayout(2, false));
        BoldLabel title = new BoldLabel();
        title.setIcon(e.getSmallImage(modelObject));
        title.setIconAlignment(8);
        title.setText(type);
        panel.add((IFigure)title);
        Label label = new Label();
        if (!name.equals(type)) {
            label.setText(name);
        }
        panel.add((IFigure)label);
        if (e instanceof IAnnotatedElement && (annotation = ((IAnnotatedElement)((Object)e)).getAnnotation(modelObject)) != null) {
            int i = 0;
            while (i < annotation.length) {
                if (annotation[i + 1] != null && annotation[i + 1].length() > 0) {
                    panel.add((IFigure)new Label(String.valueOf(annotation[i]) + " :"));
                    panel.add((IFigure)new Label(annotation[i + 1]));
                }
                i += 2;
            }
        }
        return panel;
    }

    @Override
    public String getHoverHelp(IMarker marker) {
        return null;
    }

    protected ILabeledElement getLabeledElement(EObject modelObject) {
        if (modelObject == null) {
            return null;
        }
        for (Adapter adapter : modelObject.eAdapters()) {
            if (!(adapter instanceof ILabeledElement)) continue;
            return (ILabeledElement)adapter;
        }
        return null;
    }

    private static class BoldLabel
    extends Label {
        private BoldLabel() {
        }

        public void addNotify() {
            FontData[] fontData;
            super.addNotify();
            Font font = this.getFont();
            if (font == null) {
                return;
            }
            FontData[] fontDataArray = fontData = font.getFontData();
            int n = fontData.length;
            int n2 = 0;
            while (n2 < n) {
                FontData fd = fontDataArray[n2];
                fd.setStyle(fd.getStyle() | 1);
                ++n2;
            }
            Font bold = new Font(font.getDevice(), fontData);
            this.setFont(bold);
        }
    }
}

