/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;
import org.eclipse.bpel.common.ui.flatui.FlatFormData;
import org.eclipse.bpel.common.ui.flatui.FlatFormLayout;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DurationSelector
extends Composite {
    static final String ID = "id";
    static final String TEXT = "text";
    protected Composite topComposite;
    protected Composite[] composite;
    protected Label[] label;
    protected Text[] text;
    protected Object lastWidgetChanged;
    protected static final int YEAR = 0;
    protected static final int MONTH = 1;
    protected static final int DAY = 2;
    protected static final int HOUR = 3;
    protected static final int MINUTE = 4;
    protected static final int SECOND = 5;
    protected static final String[] labelStrings = new String[]{Messages.DurationSelector_Years_1, Messages.DurationSelector_Months_1, Messages.DurationSelector_Days_2, Messages.DurationSelector_Hours_3, Messages.DurationSelector_Minutes_4, Messages.DurationSelector_Seconds_5};
    private FormToolkit wf;

    public DurationSelector(FormToolkit toolkit, Composite parent, int style) {
        super(parent, style);
        this.wf = toolkit;
        this.setLayout((Layout)new FillLayout());
        this.createControls(this);
    }

    private void createControls(Composite parent) {
        this.topComposite = this.wf.createComposite(parent);
        GridLayout gridLayout = new GridLayout(3, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 4;
        gridLayout.horizontalSpacing = 5;
        this.topComposite.setLayout((Layout)gridLayout);
        this.composite = new Composite[6];
        this.text = new Text[6];
        this.label = new Label[6];
        int i = 0;
        while (i < 6) {
            this.composite[i] = this.wf.createComposite(this.topComposite);
            this.composite[i].setLayoutData((Object)new GridData(768));
            FlatFormLayout formLayout = new FlatFormLayout();
            formLayout.marginHeight = 0;
            formLayout.marginWidth = 0;
            this.composite[i].setLayout((Layout)formLayout);
            this.label[i] = this.wf.createLabel(this.composite[i], labelStrings[i], 0x1000000);
            this.text[i] = this.wf.createText(this.composite[i], "0");
            this.text[i].setData(ID, (Object)i);
            FlatFormData data = new FlatFormData();
            data.left = new FlatFormAttachment(0, 0);
            data.right = new FlatFormAttachment(100, 0);
            data.top = new FlatFormAttachment(0, 0);
            this.label[i].setLayoutData((Object)data);
            data = new FlatFormData();
            data.left = new FlatFormAttachment(0, 0);
            data.right = new FlatFormAttachment(100, 0);
            data.top = new FlatFormAttachment((Control)this.label[i], 4);
            this.text[i].setLayoutData((Object)data);
            ++i;
        }
        this.addListeners();
        this.layout(true);
    }

    private void addListeners() {
        FocusListener focusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                Text w = (Text)e.widget;
                w.setData(DurationSelector.TEXT, (Object)w.getText().trim());
            }

            public void focusLost(FocusEvent e) {
                Text w = (Text)e.widget;
                String cv = w.getText();
                String ct = cv.trim();
                String ov = (String)w.getData(DurationSelector.TEXT);
                if (!DurationSelector.this.isValidValue(ct, (Integer)w.getData(DurationSelector.ID))) {
                    w.setText(ov);
                    return;
                }
                if (!ct.equals(cv)) {
                    w.setText(ct);
                }
                if (!ct.equals(ov)) {
                    DurationSelector.this.lastWidgetChanged = w.getData(DurationSelector.ID);
                    DurationSelector.this.selectionChanged();
                }
            }
        };
        int i = 0;
        while (i < 6) {
            this.text[i].addFocusListener(focusListener);
            ++i;
        }
    }

    boolean isValidValue(String value, Integer type) {
        int n = this.numberValue(value);
        if (n < 0) {
            return false;
        }
        switch (type) {
            case 0: {
                return n < 999;
            }
            case 1: {
                return n < 12;
            }
            case 2: {
                return n < 31;
            }
            case 3: {
                return n < 24;
            }
            case 4: 
            case 5: {
                return n < 59;
            }
        }
        return false;
    }

    protected int numberValue(String s) {
        int result = 0;
        try {
            result = Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {}
        return result;
    }

    public int[] getValues() {
        int[] result = new int[6];
        int i = 0;
        while (i < 6) {
            result[i] = this.numberValue(this.text[i].getText());
            ++i;
        }
        return result;
    }

    public boolean setValues(int[] duration) {
        int i = 0;
        while (i < 6) {
            this.text[i].setText(String.valueOf(duration[i]));
            ++i;
        }
        return true;
    }

    void selectionChanged() {
        Event e = new Event();
        e.type = 13;
        e.widget = this;
        e.widget.notifyListeners(e.type, e);
    }

    public void addSelectionListener(SelectionListener listener) {
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
    }

    public Object getUserContext() {
        return this.lastWidgetChanged;
    }

    public void restoreUserContext(Object userContext) {
        int i = (Integer)userContext;
        if (i >= 0) {
            this.text[i].setFocus();
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        int i = 0;
        while (i < this.text.length) {
            this.text[i].setEnabled(enabled);
            ++i;
        }
    }
}

