/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import org.eclipse.bpel.common.ui.details.ButtonIValue;
import org.eclipse.bpel.common.ui.details.DelegateIValue;
import org.eclipse.bpel.common.ui.details.FocusContext;
import org.eclipse.bpel.common.ui.details.IValue;
import org.eclipse.bpel.common.ui.details.TextIValue;
import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;
import org.eclipse.bpel.common.ui.flatui.FlatFormData;
import org.eclipse.bpel.model.BPELFactory;
import org.eclipse.bpel.model.BPELPackage;
import org.eclipse.bpel.model.Variable;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.properties.BPELPropertySection;
import org.eclipse.bpel.ui.properties.EditController;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.XSDUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xsd.XSDTypeDefinition;

public class ForEachSection
extends BPELPropertySection {
    Text fCounterNameText;
    Composite counterNameVariableComposite;
    Button fIsParallelCheckbox;
    Composite isParallelComposite;
    EditController fParallelExecutionController;
    EditController fVariableNameController;
    IValue fContext;

    @Override
    public Object getUserContext() {
        return this.fContext.get();
    }

    @Override
    public void restoreUserContext(Object userContext) {
        this.fContext.set(userContext);
    }

    @Override
    protected void basicSetInput(EObject newInput) {
        super.basicSetInput(newInput);
        this.fParallelExecutionController.setInput(newInput);
        this.fVariableNameController.setInput(newInput);
    }

    void createChangeTrackers() {
        this.fParallelExecutionController = this.createEditController();
        this.fParallelExecutionController.setFeature((EStructuralFeature)BPELPackage.eINSTANCE.getForEach_Parallel());
        this.fParallelExecutionController.setViewIValue((IValue)new ButtonIValue(this.fIsParallelCheckbox));
        this.fParallelExecutionController.startListeningTo(new Control[]{this.fIsParallelCheckbox});
        this.fVariableNameController = this.createEditController();
        this.fVariableNameController.setFeature((EStructuralFeature)BPELPackage.eINSTANCE.getForEach_CounterName());
        this.fVariableNameController.setViewIValue((IValue)new DelegateIValue((IValue)new TextIValue(this.fCounterNameText)){

            public Object get() {
                String name = (String)this.fDelegate.get();
                if (name.length() == 0) {
                    return null;
                }
                Variable variable = BPELFactory.eINSTANCE.createVariable();
                variable.setName(name);
                variable.setType((XSDTypeDefinition)XSDUtils.getPrimitive("unsignedInt"));
                return variable;
            }

            public void set(Object object) {
                if (object == null) {
                    this.fDelegate.set(null);
                } else {
                    this.fDelegate.set((Object)((Variable)object).getName());
                }
            }
        });
        this.fVariableNameController.startListeningTo(new Control[]{this.fCounterNameText});
    }

    private void createCounterNameWidgets(Composite parentComposite) {
        this.counterNameVariableComposite = this.createFlatFormComposite(parentComposite);
        FlatFormData data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.top = new FlatFormAttachment((Control)this.isParallelComposite, 4);
        data.right = new FlatFormAttachment(100, 0);
        this.counterNameVariableComposite.setLayoutData((Object)data);
        Label variableLabel = this.fWidgetFactory.createLabel(this.counterNameVariableComposite, Messages.ForEachSection_COUNTER_NAME);
        this.fCounterNameText = this.fWidgetFactory.createText(this.counterNameVariableComposite, "");
        data = new FlatFormData();
        data.top = new FlatFormAttachment(0, 0);
        data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth((Widget)variableLabel, 131));
        data.right = new FlatFormAttachment(100, 0);
        this.fCounterNameText.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment((Control)this.fCounterNameText, -5);
        data.top = new FlatFormAttachment((Control)this.fCounterNameText, 0, 0x1000000);
        variableLabel.setLayoutData((Object)data);
    }

    private void createIsParallelWidgets(Composite parentComposite) {
        this.isParallelComposite = this.createFlatFormComposite(parentComposite);
        FlatFormData data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.top = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(100, 0);
        this.isParallelComposite.setLayoutData((Object)data);
        this.fIsParallelCheckbox = this.fWidgetFactory.createButton(this.isParallelComposite, Messages.ForEachSection_IS_PARALLEL, 32);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.top = new FlatFormAttachment(0, 0);
        this.fIsParallelCheckbox.setLayoutData((Object)data);
    }

    @Override
    protected void createClient(Composite parent) {
        Composite parentComposite = this.createFlatFormComposite(parent);
        this.createIsParallelWidgets(parentComposite);
        this.createCounterNameWidgets(parentComposite);
        this.fContext = new FocusContext(new Control[]{this.fIsParallelCheckbox, this.fCounterNameText});
        this.createChangeTrackers();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parentComposite, "org.eclipse.bpel.ui.property_for_each");
    }
}

