/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.util;

import java.util.HashSet;
import org.eclipse.bpel.ui.util.AbstractSharedCommandStackListener;
import org.eclipse.bpel.ui.util.IBatchedAdapter;

public class CommandStackChangeBatcher
extends AbstractSharedCommandStackListener {
    protected static boolean batchingChanges;
    public static HashSet<IBatchedAdapter> liveBatchedAdapters;
    static final IBatchedAdapter[] EMPTY;

    static {
        liveBatchedAdapters = new HashSet();
        EMPTY = new IBatchedAdapter[0];
    }

    protected void startBatch() {
        if (batchingChanges) {
            return;
        }
        batchingChanges = true;
        liveBatchedAdapters.clear();
    }

    protected void finishBatch() {
        batchingChanges = false;
        IBatchedAdapter[] iBatchedAdapterArray = liveBatchedAdapters.toArray(EMPTY);
        int n = iBatchedAdapterArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBatchedAdapter adapter = iBatchedAdapterArray[n2];
            adapter.finish();
            ++n2;
        }
        liveBatchedAdapters.clear();
    }

    public static boolean isBatchingChanges() {
        return batchingChanges;
    }

    public static void registerBatchChange(IBatchedAdapter adapter) {
        liveBatchedAdapters.add(adapter);
    }

    @Override
    protected void startExecute() {
        this.startBatch();
    }

    @Override
    protected void startRedo() {
        this.startBatch();
    }

    @Override
    protected void startUndo() {
        this.startBatch();
    }

    @Override
    protected void finishExecute() {
        this.finishBatch();
    }

    @Override
    protected void finishRedo() {
        this.finishBatch();
    }

    @Override
    protected void finishUndo() {
        this.finishBatch();
    }
}

