/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.model;

import javax.xml.namespace.QName;
import org.eclipse.bpel.validator.helpers.NCNameWordDetector;
import org.eclipse.bpel.validator.model.Filter;
import org.eclipse.bpel.validator.model.IConstants;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.NodeNameFilter;
import org.eclipse.bpel.validator.model.ValueFilter;

public class Filters
implements IConstants {
    public static final IFilter<INode> SCOPE_OR_PROCESS = new NodeNameFilter(ND_SCOPE, ND_PROCESS);
    public static final IFilter<INode> SCOPE = new NodeNameFilter(ND_SCOPE);
    public static final IFilter<INode> PROCESS = new NodeNameFilter(ND_PROCESS);
    public static final IFilter<INode> FLOW = new NodeNameFilter(ND_FLOW);
    public static final IFilter<String> BOOLEAN_FILTER = new ValueFilter<String>(Filter.STRING_COMPARATOR, BOOLEAN_VALUES);
    public static final IFilter<String> INITIATE_FILTER = new ValueFilter<String>(Filter.STRING_COMPARATOR, INITIATE_VALUES);
    public static final IFilter<String> ENDPOINT_FILTER = new ValueFilter<String>(Filter.STRING_COMPARATOR, ENDPOINT_VALUES);
    public static final IFilter<String> PATTERN_FILTER = new ValueFilter<String>(Filter.STRING_COMPARATOR, PATTERN_VALUES);
    public static final IFilter<INode> REPEATABLE_CONSTRUCT = new NodeNameFilter(REPEATABLE_NODES);
    public static final IFilter<INode> FAULT_HANDLER_BOUNDARY = new NodeNameFilter(FAULT_HANDLER_BOUNDARY_NODES);
    public static final IFilter<INode> FCT_HANDLER = new NodeNameFilter(FCT_HANDLERS);
    public static final IFilter<INode> ACTIVITIES = new NodeNameFilter(BPEL_ACTIVITIES){

        @Override
        public String toString() {
            return "text.bpel.activities.filter";
        }
    };
    public static final IFilter<INode> ACTIVITY_CONTAINER = new NodeNameFilter(BPEL_ACTIVITIES_CONTAINERS){

        @Override
        public String toString() {
            return "text.bpel.activities.container.filter";
        }
    };
    public static final IFilter<INode> ANY = new NodeNameFilter(new QName("*"));
    public static final IFilter<INode> EMPTY = new NodeNameFilter(new QName[0]);
    public static final IFilter<String> NC_NAME = new IFilter<String>(){
        NCNameWordDetector fWordDetector = new NCNameWordDetector();

        @Override
        public boolean select(String name) {
            return this.fWordDetector.isValid(name);
        }

        public String toString() {
            return "Valid-NCName";
        }
    };
    public static final IFilter<QName> STANDARD_FAULTS = new ValueFilter<QName>(Filter.QNAME_COMPARATOR, BPEL_STANDARD_FAULTS);
}

