/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.choreography;

import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.CallChoreography;
import org.eclipse.bpmn2.SubChoreography;
import org.eclipse.bpmn2.modeler.core.features.label.UpdateLabelFeature;
import org.eclipse.bpmn2.modeler.core.preferences.ShapeStyle;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;

public class UpdateChoreographyLabelFeature
extends UpdateLabelFeature {
    public UpdateChoreographyLabelFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    protected ShapeStyle.LabelPosition getHorizontalLabelPosition(AbstractText text) {
        PictogramElement pe = FeatureSupport.getLabelOwner((GraphicsAlgorithm)text);
        Object bo = this.getBusinessObjectForPictogramElement(pe);
        if ((bo instanceof SubChoreography || bo instanceof CallChoreography) && FeatureSupport.isElementExpanded((BaseElement)bo)) {
            return ShapeStyle.LabelPosition.LEFT;
        }
        return ShapeStyle.LabelPosition.CENTER;
    }

    @Override
    protected ShapeStyle.LabelPosition getVerticalLabelPosition(AbstractText text) {
        PictogramElement pe = FeatureSupport.getLabelOwner((GraphicsAlgorithm)text);
        Object bo = this.getBusinessObjectForPictogramElement(pe);
        if ((bo instanceof SubChoreography || bo instanceof CallChoreography) && FeatureSupport.isElementExpanded((BaseElement)bo)) {
            return ShapeStyle.LabelPosition.TOP;
        }
        return ShapeStyle.LabelPosition.CENTER;
    }

    @Override
    protected Rectangle getLabelBounds(PictogramElement pe, boolean isAddingLabel, Point offset) {
        Object bo;
        Rectangle bounds = super.getLabelBounds(pe, isAddingLabel, offset);
        if (!isAddingLabel && ((bo = this.getBusinessObjectForPictogramElement(pe)) instanceof SubChoreography || bo instanceof CallChoreography) && FeatureSupport.isElementExpanded((BaseElement)bo)) {
            ContainerShape choreographyActivityShape = (ContainerShape)FeatureSupport.getLabelOwner(pe);
            List<ContainerShape> bandShapes = FeatureSupport.getParticipantBandContainerShapes(choreographyActivityShape);
            List<ContainerShape> topBandShapes = FeatureSupport.getTopAndBottomBands(bandShapes).getFirst();
            int dy = 0;
            for (ContainerShape s : topBandShapes) {
                dy += Graphiti.getGaLayoutService().calculateSize(s.getGraphicsAlgorithm()).getHeight();
            }
            bounds.setY(bounds.y + dy);
        }
        return bounds;
    }

    @Override
    protected ContainerShape getTargetContainer(PictogramElement ownerPE) {
        return (ContainerShape)ownerPE;
    }
}

