/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.service.command.events;

import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.gdb.internal.service.command.events.EventMessages;
import org.eclipse.cdt.dsf.mi.service.command.events.MIBreakpointHitEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIStoppedEvent;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIFrame;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;

@Immutable
public class MITracepointSelectedEvent
extends MIBreakpointHitEvent {
    private int fRecNo;

    protected MITracepointSelectedEvent(IRunControl.IExecutionDMContext ctx, int token, MIResult[] results, MIFrame frame, String trptno, int recordno) {
        super(ctx, token, results, frame, trptno);
        this.fRecNo = recordno;
    }

    public String getReason() {
        return String.valueOf(EventMessages.Tracepoint) + " " + this.getNumber() + ", " + EventMessages.Record + " " + this.fRecNo;
    }

    @ConfinedToDsfExecutor(value="")
    public static MITracepointSelectedEvent parse(IRunControl.IExecutionDMContext dmc, int token, MIResult[] results) {
        String trptno = "";
        int recordno = -1;
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            String str = "";
            if (value != null && value instanceof MIConst) {
                str = ((MIConst)value).getString();
            }
            if (var.equals("tracepoint")) {
                try {
                    trptno = str.trim();
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (var.equals("traceframe")) {
                try {
                    recordno = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ++i;
        }
        MIStoppedEvent stoppedEvent = MIStoppedEvent.parse(dmc, token, results);
        return new MITracepointSelectedEvent((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), token, results, stoppedEvent.getFrame(), trptno, recordno);
    }
}

