/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.portfolio.task.ant.engine;

import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.portfolio.task.ant.engine.DataConvert;

public class TaskProductionForAnt
extends Task {
    Vector<WriteOUT> writeTasks = new Vector();
    Vector<ReadIN> readTasks = new Vector();

    public void execute() throws BuildException {
        super.execute();
        try {
            this.writeContracts();
            this.readContracts();
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage());
        }
    }

    public ITaskProductionContext getContext() {
        Object context = this.getProject().getReference("TaskProductionContext");
        if (context != null && context instanceof ITaskProductionContext) {
            return (ITaskProductionContext)context;
        }
        return null;
    }

    public ReadIN createReadIN() {
        ReadIN read = new ReadIN();
        this.readTasks.add(read);
        return read;
    }

    public WriteOUT createWriteOUT() {
        WriteOUT write = new WriteOUT();
        this.writeTasks.add(write);
        return write;
    }

    private void readContracts() throws Exception {
        for (ReadIN read : this.readTasks) {
            this.doRead(read);
        }
    }

    private void writeContracts() throws Exception {
        for (WriteOUT write : this.writeTasks) {
            this.doWrite(write);
        }
    }

    private void doRead(ReadIN read) throws Exception {
        String type = read.getType();
        String name = read.getName();
        ITaskProductionContext context = this.getContext();
        if (name != null && context != null) {
            Class inputValueType = null;
            inputValueType = type == null ? context.getInputValueType((Object)name) : DataConvert.getType(type);
            Object inputValue = context.getInputValue((Object)name, inputValueType);
            this.getProject().setProperty(name, inputValue.toString());
        }
    }

    private void doWrite(WriteOUT write) throws Exception {
        String type = write.getType();
        String value = write.getValue();
        String name = write.getName();
        ITaskProductionContext context = this.getContext();
        if (name != null && value != null && context != null) {
            if (type == null) {
                Class outputValueType = context.getOutputValueType((Object)name);
                String className = outputValueType.getName();
                String typeName = outputValueType.getName().substring(className.lastIndexOf(".") + 1);
                type = "type:" + typeName;
            }
            context.setOutputValue((Object)name, DataConvert.getConvertVaule(type, value));
        }
    }

    public class ReadIN {
        private String name;
        private String type;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    public class WriteOUT
    extends ReadIN {
        private String value;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

