/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.sharing;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.op.ConnectProviderOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.sharing.ExistingOrNewPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.team.ui.IConfigurationWizard;
import org.eclipse.team.ui.IConfigurationWizardExtension;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.MoveProjectOperation;

public class SharingWizard
extends Wizard
implements IConfigurationWizard,
IConfigurationWizardExtension {
    IProject[] projects;
    private ExistingOrNewPage existingPage;

    public SharingWizard() {
        this.setWindowTitle(UIText.SharingWizard_windowTitle);
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IProject[] p) {
        this.projects = new IProject[p.length];
        System.arraycopy(p, 0, this.projects, 0, p.length);
    }

    public void init(IWorkbench workbench, IProject p) {
        this.projects = new IProject[]{p};
    }

    public void addPages() {
        this.existingPage = new ExistingOrNewPage(this);
        this.addPage((IWizardPage)this.existingPage);
    }

    public boolean performFinish() {
        final IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (!this.existingPage.getInternalMode()) {
            try {
                final Map<IProject, File> projectsToMove = this.existingPage.getProjects(true);
                final Repository selectedRepository = this.existingPage.getSelectedRepository();
                this.getContainer().run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(projectsToMove.size() * 2));
                        for (Map.Entry entry : projectsToMove.entrySet()) {
                            block8: {
                                SharingWizard.this.closeOpenEditorsForProject(activePage, (IProject)entry.getKey());
                                Path targetLocation = new Path(((File)entry.getValue()).getPath());
                                IPath currentLocation = ((IProject)entry.getKey()).getLocation();
                                if (!targetLocation.equals((Object)currentLocation)) {
                                    MoveProjectOperation op = new MoveProjectOperation((IProject)entry.getKey(), ((File)entry.getValue()).toURI(), UIText.SharingWizard_MoveProjectActionLabel);
                                    try {
                                        IStatus result = op.execute((IProgressMonitor)progress.newChild(1), null);
                                        if (!result.isOK()) {
                                            throw new RuntimeException();
                                        }
                                        break block8;
                                    }
                                    catch (ExecutionException e) {
                                        if (e.getCause() != null) {
                                            throw new InvocationTargetException(e.getCause());
                                        }
                                        throw new InvocationTargetException(e);
                                    }
                                }
                                progress.worked(1);
                            }
                            try {
                                new ConnectProviderOperation((IProject)entry.getKey(), selectedRepository.getDirectory()).execute((IProgressMonitor)progress.newChild(1));
                            }
                            catch (CoreException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                Activator.handleError(UIText.SharingWizard_failed, e.getCause(), true);
                return false;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            return true;
        }
        final ConnectProviderOperation op = new ConnectProviderOperation(this.existingPage.getProjects(true));
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        op.execute(monitor);
                        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                HashSet<File> filesToAdd = new HashSet<File>();
                                for (Map.Entry<IProject, File> entry : SharingWizard.this.existingPage.getProjects(true).entrySet()) {
                                    filesToAdd.add(entry.getValue());
                                }
                                for (File file : filesToAdd) {
                                    RepositoryUtil.getInstance().addConfiguredRepository(file);
                                }
                            }
                        });
                    }
                    catch (CoreException ce) {
                        throw new InvocationTargetException(ce);
                    }
                }
            });
            return true;
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = e.getCause();
            }
            if (e instanceof CoreException) {
                IStatus status = ((CoreException)e).getStatus();
                e = status.getException();
            }
            Activator.handleError(UIText.SharingWizard_failed, e, true);
            return false;
        }
    }

    private void closeOpenEditorsForProject(final IWorkbenchPage activePage, IProject project) {
        final List<IEditorReference> editorRefsToClose = this.findEditorReferencesForProject(activePage, project);
        if (editorRefsToClose.isEmpty()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                activePage.closeEditors(editorRefsToClose.toArray(new IEditorReference[0]), true);
            }
        });
    }

    private List<IEditorReference> findEditorReferencesForProject(IWorkbenchPage activePage, IProject project) {
        ArrayList<IEditorReference> fileEditors = new ArrayList<IEditorReference>();
        IEditorReference[] iEditorReferenceArray = activePage.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorReference = iEditorReferenceArray[n2];
            try {
                IFileEditorInput fileEditorInput;
                IFile file;
                IEditorInput editorInput = editorReference.getEditorInput();
                if (editorInput instanceof IFileEditorInput && (file = (fileEditorInput = (IFileEditorInput)editorInput).getFile()).getProject().equals((Object)project)) {
                    fileEditors.add(editorReference);
                }
            }
            catch (PartInitException e) {
                Activator.logError("PartInitException - should not happen", e);
            }
            ++n2;
        }
        return fileEditors;
    }

    public boolean canFinish() {
        return this.existingPage.isPageComplete();
    }
}

