/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.branch;

import java.text.MessageFormat;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;

public class CDOBranchPointImpl
implements CDOBranchPoint,
Comparable<CDOBranchPoint> {
    private final CDOBranch branch;
    private final long timeStamp;

    public CDOBranchPointImpl(CDOBranch branch, long timeStamp) {
        this.branch = branch;
        this.timeStamp = timeStamp;
    }

    @Override
    public CDOBranch getBranch() {
        return this.branch;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public int compareTo(CDOBranchPoint o) {
        int result = this.branch.compareTo(o.getBranch());
        if (result == 0) {
            result = CDOCommonUtil.compareTimeStamps(this.timeStamp, o.getTimeStamp());
        }
        return result;
    }

    public int hashCode() {
        return this.branch.hashCode() ^ Long.valueOf(this.timeStamp).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CDOBranchPoint) {
            CDOBranchPoint that = (CDOBranchPoint)obj;
            return this.branch == that.getBranch() && this.timeStamp == that.getTimeStamp();
        }
        return false;
    }

    public String toString() {
        return MessageFormat.format("BranchPoint[{0}, {1}]", this.branch, CDOCommonUtil.formatTimeStamp(this.timeStamp));
    }
}

