/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.embedded;

import java.util.ArrayList;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.internal.server.Repository;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.embedded.CDOEmbeddedRepositoryConfig;
import org.eclipse.emf.cdo.server.internal.embedded.ClientBranchManager;
import org.eclipse.emf.cdo.server.internal.embedded.ClientRevisionManager;
import org.eclipse.emf.cdo.server.internal.embedded.ServerBranchLoader;
import org.eclipse.emf.cdo.server.internal.embedded.ServerRevisionLoader;
import org.eclipse.emf.cdo.server.net4j.CDONet4jServerUtil;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.server.InternalStore;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.acceptor.IAcceptor;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.jvm.JVMUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;

public class EmbeddedRepository
extends Repository.Default {
    private CDOEmbeddedRepositoryConfig config;
    private IAcceptor acceptor;
    private IConnector connector;

    public EmbeddedRepository(CDOEmbeddedRepositoryConfig config) {
        this.config = config;
    }

    public CDONet4jSession openClientSession() {
        ClientBranchManager branchManager = new ClientBranchManager(this.getBranchManager());
        ClientRevisionManager revisionManager = new ClientRevisionManager(this.getRevisionManager());
        CDONet4jSessionConfiguration configuration = this.config.createSessionConfiguration(this.connector, (CDOBranchManager)branchManager, (CDORevisionManager)revisionManager);
        CDONet4jSession session = configuration.openNet4jSession();
        this.config.modifySession((IRepository)this, session);
        return session;
    }

    public void initSystemPackages(boolean firstStart) {
        if (firstStart) {
            ArrayList<EPackage> packages = new ArrayList<EPackage>();
            this.config.initPackages((IRepository)this, packages);
            if (!packages.isEmpty()) {
                this.setInitialPackages(packages.toArray(new EPackage[packages.size()]));
            }
        }
        super.initSystemPackages(firstStart);
    }

    protected void doBeforeActivate() throws Exception {
        if (!OMPlatform.INSTANCE.isExtensionRegistryAvailable()) {
            IManagedContainer container = this.getContainer();
            Net4jUtil.prepareContainer((IManagedContainer)container);
            JVMUtil.prepareContainer((IManagedContainer)container);
            CDONet4jServerUtil.prepareContainer((IManagedContainer)container);
        }
        super.doBeforeActivate();
        InternalCDOBranchManager branchManager = this.getBranchManager();
        branchManager.setBranchLoader((InternalCDOBranchManager.BranchLoader)new ServerBranchLoader((InternalCDOBranchManager.BranchLoader4)this));
        InternalCDORevisionManager revisionManager = this.getRevisionManager();
        revisionManager.setRevisionLoader((InternalCDORevisionManager.RevisionLoader)new ServerRevisionLoader((InternalCDORevisionManager.RevisionLoader2)this));
    }

    protected void doAfterActivate() throws Exception {
        super.doAfterActivate();
        IManagedContainer container = this.getContainer();
        container.putElement("org.eclipse.emf.cdo.server.repositories", "default", this.getName(), (Object)this);
        this.acceptor = this.config.createAcceptor(container);
        this.connector = this.config.createConnector(container);
        InternalStore store = this.getStore();
        if (store.isFirstStart()) {
            this.config.afterFirstStart((IRepository)this);
        } else {
            this.config.afterReStart((IRepository)this);
        }
    }

    protected void doDeactivate() throws Exception {
        LifecycleUtil.deactivate((Object)this.connector);
        this.connector = null;
        LifecycleUtil.deactivate((Object)this.acceptor);
        this.acceptor = null;
        super.doDeactivate();
    }
}

