/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.transfer.spi.repository;

import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.lob.CDOBlob;
import org.eclipse.emf.cdo.common.lob.CDOClob;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.eresource.CDOBinaryResource;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.eresource.CDOTextResource;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transfer.CDOTransferElement;
import org.eclipse.emf.cdo.transfer.CDOTransferSystem;
import org.eclipse.emf.cdo.transfer.CDOTransferType;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.io.IOUtil;

public class RepositoryTransferSystem
extends CDOTransferSystem {
    public static final String TYPE = "repository";
    private final CDOView view;

    public RepositoryTransferSystem(CDOView view) {
        super(view.isReadOnly());
        this.view = view;
    }

    public String getType() {
        return TYPE;
    }

    public CDOView getView() {
        return this.view;
    }

    public RepositoryTransferSystem makeWriteable() {
        if (this.isReadOnly()) {
            CDOBranch branch = this.view.getBranch();
            CDOSession session = this.view.getSession();
            CDOTransaction transaction = session.openTransaction(branch);
            return new RepositoryTransferSystem((CDOView)transaction);
        }
        return this;
    }

    public CDOTransferType getDefaultTransferType(CDOTransferElement element) {
        if (element instanceof Element) {
            CDOResourceNode node = ((Element)element).node;
            if (node instanceof CDOResource) {
                return CDOTransferType.MODEL;
            }
            if (node instanceof CDOTextResource) {
                String encoding = ((CDOTextResource)node).getEncoding();
                return CDOTransferType.text((String)encoding);
            }
            if (node instanceof CDOBinaryResource) {
                return CDOTransferType.BINARY;
            }
        }
        return super.getDefaultTransferType(element);
    }

    protected ResourceSet provideResourceSet() {
        return this.view.getResourceSet();
    }

    public URI getURI(IPath path) {
        return CDOURIUtil.createResourceURI((CDOView)this.view, (String)path.toString());
    }

    public CDOTransferElement getElement(IPath path) {
        if (path.isEmpty()) {
            return new RootElement(this, this.view.getRootResource());
        }
        try {
            CDOResourceNode node = this.view.getResourceNode(path.toString());
            if (node != null) {
                return new Element(this, node);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public CDOTransferElement getElement(URI uri) {
        if ("cdo".equals(uri.scheme())) {
            return this.getElement(uri.path());
        }
        return null;
    }

    public void createFolder(IPath path) {
        ((CDOTransaction)this.view).createResourceFolder(path.toString());
    }

    public void createBinary(IPath path, InputStream source, IProgressMonitor monitor) {
        try {
            try {
                monitor.beginTask("", 1);
                CDOBlob blob = new CDOBlob(source);
                CDOBinaryResource resource = ((CDOTransaction)this.view).createBinaryResource(path.toString());
                resource.setContents(blob);
                monitor.worked(1);
            }
            catch (IOException ex) {
                throw new IORuntimeException((Throwable)ex);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void createText(IPath path, InputStream source, String encoding, IProgressMonitor monitor) {
        try {
            try {
                monitor.beginTask("", 1);
                CDOClob clob = new CDOClob((Reader)new InputStreamReader(source, encoding));
                CDOTextResource resource = ((CDOTransaction)this.view).createTextResource(path.toString());
                resource.setContents(clob);
                resource.setEncoding(encoding);
                monitor.worked(1);
            }
            catch (IOException ex) {
                throw new IORuntimeException((Throwable)ex);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void saveModels(EList<Resource> resources, IProgressMonitor monitor) {
        try {
            monitor.subTask("Committing to " + (Object)((Object)this));
            CDOTransaction transaction = (CDOTransaction)this.view;
            transaction.commit(monitor);
        }
        catch (CommitException ex) {
            throw new CDOException((Throwable)ex);
        }
    }

    public String toString() {
        return "Repository " + this.view.getSession().getRepositoryInfo().getName();
    }

    private static class Element
    extends CDOTransferElement {
        private CDOResourceNode node;

        public Element(CDOTransferSystem system, CDOResourceNode node) {
            super(system);
            this.node = node;
        }

        public Object getNativeObject() {
            return this.node;
        }

        public IPath getPath() {
            return new Path(this.node.getPath());
        }

        public boolean isDirectory() {
            return this.node instanceof CDOResourceFolder;
        }

        protected CDOTransferElement[] doGetChildren() {
            EList children = ((CDOResourceFolder)this.node).getNodes();
            int size = children.size();
            CDOTransferElement[] result = new Element[size];
            int i = 0;
            while (i < size) {
                CDOResourceNode child = (CDOResourceNode)children.get(i);
                result[i] = new Element(this.getSystem(), child);
                ++i;
            }
            return result;
        }

        protected InputStream doOpenInputStream() {
            block6: {
                try {
                    if (this.node instanceof CDOBinaryResource) {
                        CDOBinaryResource resource = (CDOBinaryResource)this.node;
                        return resource.getContents().getContents();
                    }
                    if (!(this.node instanceof CDOTextResource)) break block6;
                    CDOTextResource resource = (CDOTextResource)this.node;
                    Reader reader = resource.getContents().getContents();
                    CharArrayWriter buffer = new CharArrayWriter();
                    try {
                        IOUtil.copyCharacter((Reader)reader, (Writer)buffer);
                    }
                    finally {
                        IOUtil.close((Closeable)reader);
                    }
                    String encoding = resource.getEncoding();
                    byte[] bytes = buffer.toString().getBytes(encoding);
                    return new ByteArrayInputStream(bytes);
                }
                catch (IOException ex) {
                    throw new IORuntimeException((Throwable)ex);
                }
            }
            throw new IllegalStateException("Not a file resource: " + this.node);
        }
    }

    private static class RootElement
    extends CDOTransferElement {
        private CDOResource rootResource;

        public RootElement(CDOTransferSystem system, CDOResource rootResource) {
            super(system);
            this.rootResource = rootResource;
        }

        public Object getNativeObject() {
            return this.rootResource;
        }

        public IPath getPath() {
            return Path.EMPTY;
        }

        public boolean isDirectory() {
            return true;
        }

        protected CDOTransferElement[] doGetChildren() {
            EList children = this.rootResource.getContents();
            int size = children.size();
            CDOTransferElement[] result = new Element[size];
            int i = 0;
            while (i < size) {
                CDOResourceNode child = (CDOResourceNode)children.get(i);
                result[i] = new Element(this.getSystem(), child);
                ++i;
            }
            return result;
        }

        protected InputStream doOpenInputStream() {
            throw new UnsupportedOperationException();
        }
    }
}

