/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cheatsheets.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.cheatsheets.CheatSheetsPlugin;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.cheatsheets.ICheatSheetAction;
import org.eclipse.ui.cheatsheets.ICheatSheetManager;

public class NewProjectAction
extends Action
implements ICheatSheetAction {
    protected String projectName;

    public void run(String[] params, ICheatSheetManager manager) {
        this.projectName = params[0];
        this.run();
    }

    public void run() {
        if (this.projectName != null) {
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    NewProjectAction.this.createProject(NewProjectAction.this.projectName, monitor);
                }
            };
            try {
                this.runWithProgress((IRunnableWithProgress)operation);
                this.notifyResult(ResourcesPlugin.getWorkspace().getRoot().exists((IPath)new Path(this.projectName)));
                return;
            }
            catch (Exception e) {
                CheatSheetsPlugin.INSTANCE.log(e);
            }
        }
        this.notifyResult(false);
    }

    protected void runWithProgress(IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(false, false, runnable);
    }

    protected IProject createProject(String projectName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(CheatSheetsPlugin.INSTANCE.getString("_UI_CreateProject_message", new String[]{projectName}), 2);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = workspaceRoot.getProject(projectName);
        if (!project.exists()) {
            project.create((IProgressMonitor)BasicMonitor.subProgress((IProgressMonitor)monitor, (int)1));
        }
        project.open((IProgressMonitor)BasicMonitor.subProgress((IProgressMonitor)monitor, (int)1));
        monitor.done();
        return project;
    }
}

