/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.common.di.renderer;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecp.view.model.common.ECPRendererTester;
import org.eclipse.emf.ecp.view.model.common.ECPStaticRendererTester;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.osgi.framework.Bundle;

public final class POJORendererFactory {
    private static final String TEST_CLASS = "testClass";
    private static final String PRIORITY = "priority";
    private static final String ELEMENT = "element";
    private static final String DYNAMIC_TEST = "dynamicTest";
    private static final String STATIC_TEST = "staticTest";
    private static final String RENDERER = "renderer";
    private static final String POINT_ID = "org.eclipse.emf.ecp.view.model.common.di.renderers";
    private static POJORendererFactory instance;
    private final Map<Class<Object>, Set<ECPRendererTester>> rendererPojos = new LinkedHashMap<Class<Object>, Set<ECPRendererTester>>();

    public static POJORendererFactory getInstance() {
        if (instance == null) {
            instance = new POJORendererFactory();
        }
        return instance;
    }

    private POJORendererFactory() {
        this.readExtensionPoint();
    }

    private void readExtensionPoint() {
        try {
            IConfigurationElement[] controls;
            IConfigurationElement[] iConfigurationElementArray = controls = Platform.getExtensionRegistry().getConfigurationElementsFor(POINT_ID);
            int n = controls.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                String plugin = configurationElement.getContributor().getName();
                String pojoClassName = configurationElement.getAttribute(RENDERER);
                Class pojoClass = this.loadClass(plugin, pojoClassName);
                LinkedHashSet<Object> tester = new LinkedHashSet<Object>();
                IConfigurationElement[] iConfigurationElementArray2 = configurationElement.getChildren();
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement childElement = iConfigurationElementArray2[n4];
                    if (STATIC_TEST.equals(childElement.getName())) {
                        String childPlugin = childElement.getContributor().getName();
                        String testerElementClassName = childElement.getAttribute(ELEMENT);
                        Class staticTestElement = this.loadClass(childPlugin, testerElementClassName);
                        int priority = Integer.parseInt(childElement.getAttribute(PRIORITY));
                        tester.add(new ECPStaticRendererTester(priority, staticTestElement));
                    } else if (DYNAMIC_TEST.equals(childElement.getName())) {
                        ECPRendererTester dynamicTester = (ECPRendererTester)childElement.createExecutableExtension(TEST_CLASS);
                        tester.add(dynamicTester);
                    }
                    ++n4;
                }
                this.rendererPojos.put(pojoClass, tester);
                ++n2;
            }
        }
        catch (InvalidRegistryObjectException invalidRegistryObjectException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private <T> Class<T> loadClass(String bundleName, String clazz) throws ClassNotFoundException {
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            throw new ClassNotFoundException(String.valueOf(clazz) + bundleName);
        }
        return bundle.loadClass(clazz);
    }

    public Object getRenderer(VElement vElement, ViewModelContext viewContext) {
        int highestPriority = -1;
        Class<Object> bestCandidate = null;
        for (Map.Entry<Class<Object>, Set<ECPRendererTester>> rendererCandidate : this.rendererPojos.entrySet()) {
            int currentPriority = -1;
            for (ECPRendererTester tester : rendererCandidate.getValue()) {
                int testerPriority = tester.isApplicable(vElement, viewContext);
                if (testerPriority <= currentPriority) continue;
                currentPriority = testerPriority;
            }
            if (currentPriority <= highestPriority) continue;
            highestPriority = currentPriority;
            bestCandidate = rendererCandidate.getKey();
        }
        if (bestCandidate == null) {
            throw new NoSuchElementException();
        }
        try {
            return bestCandidate.newInstance();
        }
        catch (InstantiationException ex) {
            throw new NoSuchElementException();
        }
        catch (IllegalAccessException ex) {
            throw new NoSuchElementException();
        }
    }
}

