/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.query.explicitpath.path;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.eef.runtime.query.explicitpath.exception.EvaluationException;
import org.eclipse.emf.eef.runtime.query.explicitpath.path.ModelNavigation;

public class ReferenceModelNavigation
implements ModelNavigation {
    public EReference feature;
    public int index;
    public EClass discriminatorType;

    public ReferenceModelNavigation(EReference feature, int index, EClass discriminatorType) {
        assert (feature.isMany()) : "Index defined for a not multi-valued attribute";
        assert (feature.getEReferenceType().isSuperTypeOf(discriminatorType)) : "Discriminator invalid";
        this.feature = feature;
        this.index = index;
        this.discriminatorType = discriminatorType;
    }

    public ReferenceModelNavigation(EReference feature, EClass discriminatorType) {
        assert (feature.getEReferenceType().isSuperTypeOf(discriminatorType)) : "Discriminator invalid";
        this.feature = feature;
        this.index = -1;
        this.discriminatorType = discriminatorType;
    }

    public ReferenceModelNavigation(EReference feature, int index) {
        assert (feature.isMany()) : "Index defined for a not multi-valued attribute";
        this.feature = feature;
        this.index = index;
        this.discriminatorType = null;
    }

    public ReferenceModelNavigation(EReference feature) {
        this.feature = feature;
        this.index = -1;
        this.discriminatorType = null;
    }

    public Object evaluate(EObject value) throws EvaluationException {
        try {
            Object eGet = value.eGet((EStructuralFeature)this.feature);
            if (this.discriminatorType != null) {
                if (eGet instanceof EList) {
                    ArrayList<EObject> tmp = new ArrayList<EObject>();
                    EList eList = (EList)eGet;
                    for (EObject eObject : eList) {
                        if (!eObject.eClass().equals(this.discriminatorType)) continue;
                        tmp.add(eObject);
                    }
                    if (this.index >= 0) {
                        return tmp.get(this.index);
                    }
                    return tmp;
                }
                throw new EvaluationException("Discriminator type used on non many reference.");
            }
            if (this.index >= 0) {
                if (eGet instanceof EList) {
                    return ((EList)eGet).get(this.index);
                }
                throw new EvaluationException("Index used on non many reference.");
            }
            return eGet;
        }
        catch (Exception e) {
            throw new EvaluationException(e);
        }
    }
}

