/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.segments.mapping;

import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emfforms.internal.core.services.segments.mapping.IllegalMapTypeException;

public class MappedSetting
implements EStructuralFeature.Setting {
    private final EObject eObject;
    private final EStructuralFeature eStructuralFeature;
    private final EClass mappedEClass;
    private final EMap<EClass, Object> map;

    public MappedSetting(EObject eObject, EStructuralFeature eStructuralFeature, EClass mappedEClass) throws IllegalMapTypeException {
        this.checkMapType(eStructuralFeature);
        this.eObject = eObject;
        this.eStructuralFeature = eStructuralFeature;
        this.mappedEClass = mappedEClass;
        this.map = (EMap)eObject.eGet(eStructuralFeature);
    }

    public EObject getEObject() {
        return this.eObject;
    }

    public EStructuralFeature getEStructuralFeature() {
        return this.eStructuralFeature;
    }

    public Object get(boolean resolve) {
        return this.map.get((Object)this.mappedEClass);
    }

    public void set(Object newValue) {
        this.map.put((Object)this.mappedEClass, newValue);
    }

    public boolean isSet() {
        return this.map.get((Object)this.mappedEClass) != null;
    }

    public void unset() {
        this.map.removeKey((Object)this.mappedEClass);
    }

    private void checkMapType(EStructuralFeature structuralFeature) throws IllegalMapTypeException {
        this.checkStructuralFeature(structuralFeature);
        EClass eClass = (EClass)structuralFeature.getEType();
        EStructuralFeature keyFeature = eClass.getEStructuralFeature("key");
        EStructuralFeature valueFeature = eClass.getEStructuralFeature("value");
        if (keyFeature == null || valueFeature == null) {
            throw new IllegalMapTypeException("The given structural feature must reference a map.");
        }
        if (!EReference.class.isInstance(keyFeature)) {
            throw new IllegalMapTypeException("The keys of the map referenced by the given structural feature must be referenced EClasses.");
        }
        if (!EClass.class.isAssignableFrom(((EReference)keyFeature).getEReferenceType().getInstanceClass())) {
            throw new IllegalMapTypeException("The keys of the map referenced by the given structural feature must be referenced EClasses.");
        }
    }

    private void checkStructuralFeature(EStructuralFeature structuralFeature) throws IllegalMapTypeException {
        if (structuralFeature.getEType() == null) {
            throw new IllegalMapTypeException("The EType of the given structural feature was null.");
        }
        if (structuralFeature.getEType().getInstanceClassName() == null) {
            throw new IllegalMapTypeException("The InstanceClassName of the given structural feature's EType was null.");
        }
        if (!structuralFeature.getEType().getInstanceClassName().equals("java.util.Map$Entry")) {
            throw new IllegalMapTypeException("The given structural feature must reference a map.");
        }
        if (structuralFeature.getLowerBound() != 0 || structuralFeature.getUpperBound() != -1) {
            throw new IllegalMapTypeException("The given structural feature must reference a map.");
        }
    }
}

