/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.segments.mapping;

import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReferenceSegment;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsSegmentResolver;
import org.eclipse.emfforms.spi.core.services.structuralchange.StructuralChangeSegmentTester;
import org.eclipse.emfforms.spi.view.mappingsegment.model.VMappingDomainModelReferenceSegment;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(name="MappingSegmentStructuralChangeTester")
public class MappingSegmentStructuralChangeTester
implements StructuralChangeSegmentTester {
    private EMFFormsSegmentResolver segmentResolver;
    private ReportService reportService;

    @Reference(unbind="-")
    protected void setEMFFormsSegmentResolver(EMFFormsSegmentResolver segmentResolver) {
        this.segmentResolver = segmentResolver;
    }

    @Reference(unbind="-")
    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public double isApplicable(VDomainModelReferenceSegment segment) {
        if (segment == null) {
            this.reportService.report(new AbstractReport("Warning: The given segment was null."));
            return Double.NEGATIVE_INFINITY;
        }
        if (VMappingDomainModelReferenceSegment.class.isInstance(segment)) {
            return 5.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public boolean isStructureChanged(VDomainModelReferenceSegment segment, EObject domainObject, ModelChangeNotification notification) {
        EReference eReference;
        EStructuralFeature.Setting setting;
        Assert.create((Object)segment).notNull().ofClass(VMappingDomainModelReferenceSegment.class);
        Assert.create((Object)domainObject).notNull();
        if (notification.getRawNotification().isTouch()) {
            return false;
        }
        VMappingDomainModelReferenceSegment mappingSegment = (VMappingDomainModelReferenceSegment)segment;
        try {
            setting = this.segmentResolver.resolveSegment((VDomainModelReferenceSegment)mappingSegment, domainObject);
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return false;
        }
        if (EReference.class.isInstance(setting.getEStructuralFeature()) && (eReference = (EReference)setting.getEStructuralFeature()).equals(notification.getStructuralFeature()) && notification.getNotifier() == setting.getEObject()) {
            Notification rawNotification = notification.getRawNotification();
            int event = rawNotification.getEventType();
            if (event == 5 || event == 6) {
                return true;
            }
            if (event == 7) {
                return false;
            }
            Map.Entry entry = null;
            if (rawNotification.getOldValue() != null) {
                entry = (Map.Entry)rawNotification.getOldValue();
            } else if (notification.getRawNotification().getNewValue() != null) {
                entry = (Map.Entry)rawNotification.getNewValue();
            }
            if (entry != null && mappingSegment.getMappedClass().equals(entry.getKey())) {
                return true;
            }
        }
        return false;
    }
}

