/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.transport.httpclient;

import java.io.IOException;
import java.net.URI;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.Configurable;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.protocol.HttpContext;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.ChainedCredentialsProvider;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.HttpClientFactory;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.HttpServiceContext;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.NTLMDomainUtil;
import org.eclipse.epp.internal.mpc.core.util.ProxyHelper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(name="org.eclipse.epp.mpc.core.http.client", service={HttpClientService.class})
public class HttpClientService {
    private HttpClient client;
    private HttpServiceContext context;
    private volatile IProxyService proxyService;

    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, updated="bindClientFactory", unbind="unbindClientFactory")
    void bindClientFactory(HttpClientFactory factory) {
        this.context = factory.build(this.context);
        this.client = this.context.getClient();
    }

    void unbindClientFactory(HttpClientFactory factory) {
    }

    @Reference(field="proxyService", unbind="unbindProxyService", policy=ReferencePolicy.DYNAMIC)
    void bindProxyService(IProxyService proxyService) {
        this.proxyService = proxyService;
    }

    void unbindProxyService(IProxyService proxyService) {
        if (this.proxyService == proxyService) {
            this.proxyService = null;
        }
    }

    public HttpResponse execute(HttpUriRequest request) throws ClientProtocolException, IOException {
        return this.execute(request, null);
    }

    public HttpResponse execute(HttpUriRequest request, HttpContext context) throws ClientProtocolException, IOException {
        HttpClientContext internalContext = context == null ? new HttpClientContext() : HttpClientContext.adapt((HttpContext)context);
        HttpUriRequest configuredRequest = this.configureRequestExecution(request, internalContext);
        return this.client.execute(configuredRequest, (HttpContext)internalContext);
    }

    private HttpUriRequest configureRequestExecution(HttpUriRequest request, HttpClientContext context) throws IOException {
        RequestConfig requestConfig = context.getRequestConfig();
        RequestConfig.Builder builder = requestConfig != null ? RequestConfig.copy((RequestConfig)requestConfig) : (request instanceof Configurable && ((Configurable)request).getConfig() != null ? RequestConfig.copy((RequestConfig)((Configurable)request).getConfig()) : (this.client instanceof Configurable && ((Configurable)this.client).getConfig() != null ? RequestConfig.copy((RequestConfig)((Configurable)this.client).getConfig()) : RequestConfig.custom()));
        this.configureRequestExecution(request, context, builder);
        RequestConfig config = builder.build();
        if (request instanceof HttpRequestBase) {
            ((HttpRequestBase)request).setConfig(config);
            return request;
        }
        return RequestBuilder.copy((HttpRequest)request).setConfig(config).build();
    }

    protected void configureRequestExecution(HttpUriRequest request, HttpClientContext context, RequestConfig.Builder builder) throws IOException {
        this.configureProxy(request.getURI(), context, builder);
    }

    private static HttpUriRequest setConfig(HttpUriRequest request, RequestConfig config) {
        if (request instanceof HttpRequestBase) {
            ((HttpRequestBase)request).setConfig(config);
        } else {
            request = RequestBuilder.copy((HttpRequest)request).setConfig(config).build();
        }
        return request;
    }

    public HttpUriRequest configureRequest(HttpUriRequest request) {
        if (this.client instanceof Configurable && ((Configurable)this.client).getConfig() != null) {
            return HttpClientService.setConfig(request, ((Configurable)this.client).getConfig());
        }
        return request;
    }

    public HttpResponse configureAndExecute(HttpUriRequest request) throws ClientProtocolException, IOException {
        return this.configureAndExecute(request, null);
    }

    public HttpResponse configureAndExecute(HttpUriRequest request, HttpContext context) throws ClientProtocolException, IOException {
        return this.execute(this.configureRequest(request), context);
    }

    public HttpClient getClient() {
        return this.client;
    }

    public IProxyService getProxyService() {
        return this.proxyService;
    }

    private IProxyData getProxyData(URI uri) {
        return this.proxyService == null ? null : ProxyHelper.getProxyData(uri, this.proxyService);
    }

    private HttpHost getProxyHost(IProxyData proxy) {
        if ("HTTPS".equals(proxy.getType()) || "HTTP".equals(proxy.getType())) {
            return new HttpHost(proxy.getHost(), proxy.getPort());
        }
        return null;
    }

    private void configureProxy(URI uri, HttpClientContext context, RequestConfig.Builder builder) throws IOException {
        IProxyData proxy = this.getProxyData(uri);
        if (proxy != null) {
            builder.setProxy(this.getProxyHost(proxy));
            this.setProxyAuthentication(context, proxy);
        } else {
            builder.setProxy(null);
        }
    }

    private void setProxyAuthentication(HttpClientContext context, IProxyData proxy) throws IOException {
        HttpHost proxyHost;
        String proxyUserID = proxy.getUserId();
        if (proxyUserID != null && (proxyHost = this.getProxyHost(proxy)) != null) {
            String domainUserID = NTLMDomainUtil.getNTLMUserName(proxyUserID);
            String password = proxy.getPassword();
            String domain = NTLMDomainUtil.getNTLMUserDomain(proxyUserID);
            if (domain != null || !proxyUserID.equals(domainUserID)) {
                String workstation = NTLMDomainUtil.getNTLMWorkstation();
                this.setAuth(context, new AuthScope(proxyHost, AuthScope.ANY_REALM, "ntlm"), (Credentials)new NTCredentials(domainUserID, password, workstation, domain));
            } else {
                this.setAuth(context, new AuthScope(proxyHost, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME), (Credentials)new UsernamePasswordCredentials(proxyUserID, password));
            }
        }
    }

    private void setAuth(HttpClientContext clientContext, AuthScope authScope, Credentials credentials) {
        CredentialsProvider authStore = clientContext.getCredentialsProvider();
        if (authStore == null) {
            authStore = new BasicCredentialsProvider();
            authStore = new ChainedCredentialsProvider(authStore, this.context.getCredentialsProvider());
            clientContext.setCredentialsProvider(authStore);
        }
        authStore.setCredentials(authScope, credentials);
    }
}

