/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.device;

import java.io.InputStream;
import java.util.Dictionary;
import java.util.Vector;
import org.eclipse.equinox.device.Activator;
import org.eclipse.equinox.device.DeviceMsg;
import org.eclipse.equinox.device.DriverTracker;
import org.eclipse.equinox.device.LogTracker;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.device.DriverLocator;
import org.osgi.util.tracker.ServiceTracker;

public class DriverLocatorTracker
extends ServiceTracker {
    protected static final String clazz = "org.osgi.service.device.DriverLocator";
    protected Activator manager;
    protected LogTracker log;
    protected Vector<Bundle> bundles;

    public DriverLocatorTracker(Activator manager) {
        super(manager.context, clazz, null);
        this.manager = manager;
        this.log = manager.log;
        this.bundles = new Vector(10, 10);
        this.open();
    }

    public Object addingService(ServiceReference reference) {
        return this.context.getService(reference);
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        this.context.ungetService(reference);
    }

    public void loadDrivers(Dictionary<String, ?> properties, DriverTracker drivers) {
        ServiceReference[] references = this.getServiceReferences();
        if (references != null) {
            int size = references.length;
            int i = 0;
            while (i < size) {
                block9: {
                    ServiceReference locator = references[i];
                    DriverLocator service = (DriverLocator)this.getService(locator);
                    if (service != null) {
                        try {
                            String[] driver_ids = service.findDrivers(properties);
                            if (driver_ids == null) break block9;
                            int count = driver_ids.length;
                            int j = 0;
                            while (j < count) {
                                String driver_id = driver_ids[j];
                                if (drivers.getDriver(driver_id) == null) {
                                    try {
                                        InputStream in = service.loadDriver(driver_id);
                                        this.installDriverBundle(driver_id, in);
                                    }
                                    catch (Throwable t) {
                                        this.log.log(locator, 1, NLS.bind((String)DeviceMsg.DriverLocator_unable_to_load_driver, (Object)driver_id), t);
                                    }
                                }
                                ++j;
                            }
                        }
                        catch (Throwable t) {
                            this.log.log(locator, 1, DeviceMsg.DriverLocator_error_calling_findDrivers, t);
                        }
                    }
                }
                ++i;
            }
        }
    }

    public void loadDriver(String driver_id, DriverTracker drivers) {
        ServiceReference[] references;
        if (drivers.getDriver(driver_id) == null && (references = this.getServiceReferences()) != null) {
            int size = references.length;
            int i = 0;
            while (i < size) {
                ServiceReference locator = references[i];
                DriverLocator service = (DriverLocator)this.getService(locator);
                if (service != null) {
                    try {
                        InputStream in = service.loadDriver(driver_id);
                        if (in != null) {
                            this.installDriverBundle(driver_id, in);
                            break;
                        }
                    }
                    catch (Throwable t) {
                        this.log.log(locator, 1, NLS.bind((String)DeviceMsg.DriverLocator_unable_to_load_driver, (Object)driver_id), t);
                    }
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installDriverBundle(String driver_id, InputStream in) {
        block9: {
            if (in != null) {
                Bundle bundle = null;
                try {
                    bundle = this.context.installBundle(driver_id, in);
                    Vector<Bundle> vector = this.bundles;
                    synchronized (vector) {
                        if (!this.bundles.contains(bundle)) {
                            this.bundles.addElement(bundle);
                        }
                    }
                    bundle.start();
                }
                catch (BundleException e) {
                    this.log.log(1, NLS.bind((String)DeviceMsg.Unable_to_install_or_start_driver_bundle, (Object)driver_id), e);
                    if (bundle == null) break block9;
                    this.bundles.removeElement(bundle);
                    try {
                        bundle.uninstall();
                    }
                    catch (BundleException ee) {
                        this.log.log(1, NLS.bind((String)DeviceMsg.Unable_to_uninstall_driver_bundle_number, (Object)driver_id), ee);
                    }
                    Object var3_3 = null;
                }
            }
        }
    }

    public void usingDriverBundle(Bundle bundle) {
        this.bundles.removeElement(bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstallDriverBundles() {
        int size;
        Object[] uninstall = null;
        Vector<Bundle> vector = this.bundles;
        synchronized (vector) {
            size = this.bundles.size();
            if (size > 0) {
                uninstall = new Bundle[size];
                this.bundles.copyInto(uninstall);
            }
        }
        int i = 0;
        while (i < size) {
            Object bundle = uninstall[i];
            if ((bundle.getState() & 1) == 0) {
                try {
                    bundle.uninstall();
                }
                catch (BundleException ee) {
                    this.log.log(1, NLS.bind((String)DeviceMsg.Unable_to_uninstall_driver_bundle, (Object)((Object)ee)));
                }
            }
            ++i;
        }
        this.bundles.removeAllElements();
    }

    public boolean isUninstallCandidate(Bundle bundle) {
        return this.bundles.contains(bundle);
    }
}

