/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.language.arrowtype;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DeprecatedShape implements Enumerator
{
    EDIAMOND(0, "ediamond", "ediamond"),
    OPEN(1, "open", "open"),
    HALFOPEN(2, "halfopen", "halfopen"),
    EMPTY(3, "empty", "empty"),
    INVEMPTY(4, "invempty", "invempty");

    public static final int EDIAMOND_VALUE = 0;
    public static final int OPEN_VALUE = 1;
    public static final int HALFOPEN_VALUE = 2;
    public static final int EMPTY_VALUE = 3;
    public static final int INVEMPTY_VALUE = 4;
    private static final DeprecatedShape[] VALUES_ARRAY;
    public static final List<DeprecatedShape> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DeprecatedShape[]{EDIAMOND, OPEN, HALFOPEN, EMPTY, INVEMPTY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DeprecatedShape get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DeprecatedShape result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DeprecatedShape getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DeprecatedShape result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DeprecatedShape get(int value) {
        switch (value) {
            case 0: {
                return EDIAMOND;
            }
            case 1: {
                return OPEN;
            }
            case 2: {
                return HALFOPEN;
            }
            case 3: {
                return EMPTY;
            }
            case 4: {
                return INVEMPTY;
            }
        }
        return null;
    }

    private DeprecatedShape(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

