/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.parts;

import java.util.Set;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeType;
import org.eclipse.gef.fx.nodes.InfiniteCanvas;
import org.eclipse.gef.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef.geometry.convert.fx.Geometry2FX;
import org.eclipse.gef.geometry.planar.Rectangle;
import org.eclipse.gef.mvc.fx.models.SnappingModel;
import org.eclipse.gef.mvc.fx.parts.AbstractFeedbackPart;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;

public class SnappingFeedbackPart
extends AbstractFeedbackPart<Line> {
    private SnappingModel.SnappingLocation snappingLocation = null;
    private ChangeListener<? super Number> viewportSizeObserver = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            SnappingFeedbackPart.this.onViewportSizeChanged();
        }
    };
    private ChangeListener<? super Number> viewportTranslationObserver = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            SnappingFeedbackPart.this.onViewportTranslationChanged();
        }
    };

    @Override
    protected void doAttachToAnchorageVisual(IVisualPart<? extends Node> anchorage, String role) {
        super.doAttachToAnchorageVisual(anchorage, role);
        if (this.getAnchoragesUnmodifiable().size() == 1) {
            InfiniteCanvas canvas = (InfiniteCanvas)anchorage.getRoot().getViewer().getCanvas();
            canvas.widthProperty().addListener(this.viewportSizeObserver);
            canvas.heightProperty().addListener(this.viewportSizeObserver);
            canvas.horizontalScrollOffsetProperty().addListener(this.viewportTranslationObserver);
            canvas.verticalScrollOffsetProperty().addListener(this.viewportTranslationObserver);
        }
    }

    @Override
    protected Line doCreateVisual() {
        Line line = new Line();
        line.setStroke((Paint)Color.RED);
        line.setStrokeWidth(1.0);
        line.setStrokeType(StrokeType.CENTERED);
        line.setStrokeLineCap(StrokeLineCap.BUTT);
        line.setVisible(false);
        return line;
    }

    @Override
    protected void doDetachFromAnchorageVisual(IVisualPart<? extends Node> anchorage, String role) {
        super.doDetachFromAnchorageVisual(anchorage, role);
        if (this.getAnchoragesUnmodifiable().isEmpty()) {
            InfiniteCanvas canvas = (InfiniteCanvas)anchorage.getRoot().getViewer().getCanvas();
            canvas.widthProperty().removeListener(this.viewportSizeObserver);
            canvas.heightProperty().removeListener(this.viewportSizeObserver);
            canvas.horizontalScrollOffsetProperty().removeListener(this.viewportTranslationObserver);
            canvas.verticalScrollOffsetProperty().removeListener(this.viewportTranslationObserver);
        }
    }

    @Override
    protected void doRefreshVisual(Line visual) {
        Set anchorages = this.getAnchoragesUnmodifiable().keySet();
        if (anchorages.isEmpty()) {
            return;
        }
        IVisualPart firstAnchorage = (IVisualPart)anchorages.iterator().next();
        if (!(firstAnchorage instanceof IContentPart)) {
            throw new IllegalStateException("SnapToLocationFeedbackPart can only be attached to IContentPart.");
        }
        IContentPart host = (IContentPart)firstAnchorage;
        InfiniteCanvas canvas = (InfiniteCanvas)host.getRoot().getViewer().getCanvas();
        Bounds canvasBoundsInScene = canvas.localToScene(canvas.getLayoutBounds());
        canvas.widthProperty().removeListener(this.viewportSizeObserver);
        canvas.heightProperty().removeListener(this.viewportSizeObserver);
        canvas.horizontalScrollOffsetProperty().removeListener(this.viewportTranslationObserver);
        canvas.verticalScrollOffsetProperty().removeListener(this.viewportTranslationObserver);
        visual.setVisible(false);
        canvas.horizontalScrollOffsetProperty().addListener(this.viewportTranslationObserver);
        canvas.verticalScrollOffsetProperty().addListener(this.viewportTranslationObserver);
        canvas.widthProperty().addListener(this.viewportSizeObserver);
        canvas.heightProperty().addListener(this.viewportSizeObserver);
        if (this.getSnappingLocation().getOrientation() == Orientation.HORIZONTAL) {
            double xInScene = this.getSnappingLocation().getPositionInScene();
            Point2D startLocal = visual.sceneToLocal(xInScene, canvasBoundsInScene.getMinY() + 3.0);
            Point2D endLocal = visual.sceneToLocal(xInScene, canvasBoundsInScene.getMaxY() - 3.0);
            double xLocal = Math.floor(startLocal.getX()) + 0.5;
            visual.setStartX(xLocal);
            visual.setStartY(Math.floor(startLocal.getY() + 1.0) + 0.5);
            visual.setEndX(xLocal);
            visual.setEndY(Math.floor(endLocal.getY() - 1.0) - 0.5);
        } else {
            double yInScene = this.getSnappingLocation().getPositionInScene();
            Point2D startLocal = visual.sceneToLocal(canvasBoundsInScene.getMinX() + 3.0, yInScene);
            Point2D endLocal = visual.sceneToLocal(canvasBoundsInScene.getMaxX() - 3.0, yInScene);
            double yLocal = Math.floor(startLocal.getY()) + 0.5;
            visual.setStartX(Math.floor(startLocal.getX() + 1.0) + 0.5);
            visual.setStartY(yLocal);
            visual.setEndX(Math.floor(endLocal.getX() - 1.0) - 0.5);
            visual.setEndY(yLocal);
        }
        Bounds visualBoundsInScene = visual.getParent().localToScene(visual.getBoundsInParent());
        visualBoundsInScene = Geometry2FX.toFXBounds((Rectangle)((Rectangle)FX2Geometry.toRectangle((Bounds)visualBoundsInScene).expand(2.0, 2.0)));
        if (canvasBoundsInScene.contains(visualBoundsInScene)) {
            canvas.widthProperty().removeListener(this.viewportSizeObserver);
            canvas.heightProperty().removeListener(this.viewportSizeObserver);
            canvas.horizontalScrollOffsetProperty().removeListener(this.viewportTranslationObserver);
            canvas.verticalScrollOffsetProperty().removeListener(this.viewportTranslationObserver);
            visual.setVisible(true);
            canvas.horizontalScrollOffsetProperty().addListener(this.viewportTranslationObserver);
            canvas.verticalScrollOffsetProperty().addListener(this.viewportTranslationObserver);
            canvas.widthProperty().addListener(this.viewportSizeObserver);
            canvas.heightProperty().addListener(this.viewportSizeObserver);
        }
    }

    public SnappingModel.SnappingLocation getSnappingLocation() {
        return this.snappingLocation;
    }

    protected void onViewportSizeChanged() {
        this.refreshVisual();
    }

    protected void onViewportTranslationChanged() {
        this.refreshVisual();
    }

    public void setSnappingLocation(SnappingModel.SnappingLocation snappingLocation) {
        this.snappingLocation = snappingLocation;
    }
}

