/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.gef.util.EditPartUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Display;

public class MarqueeSelectionTool
extends AbstractTool {
    public static final int BEHAVIOR_CONNECTIONS_CONTAINED = new Integer(6);
    public static final int BEHAVIOR_CONNECTIONS_TOUCHED = new Integer(2);
    public static final int BEHAVIOR_NODES_CONTAINED = new Integer(1);
    public static final int BEHAVIOR_NODES_CONTAINED_AND_RELATED_CONNECTIONS = new Integer(3);
    public static final int BEHAVIOR_NODES_TOUCHED = new Integer(4);
    public static final int BEHAVIOR_NODES_TOUCHED_AND_RELATED_CONNECTIONS = new Integer(5);
    public static final int BEHAVIOR_NODES_AND_CONNECTIONS = BEHAVIOR_NODES_CONTAINED_AND_RELATED_CONNECTIONS;
    static final int DEFAULT_MODE = 0;
    static final int TOGGLE_MODE = 1;
    static final int APPEND_MODE = 2;
    private static final Request MARQUEE_REQUEST = new Request("selection");
    public static final Object PROPERTY_MARQUEE_BEHAVIOR = "marqueeBehavior";
    public static final int DEFAULT_MARQUEE_BEHAVIOR = BEHAVIOR_NODES_CONTAINED;
    private Set allChildren = new HashSet();
    private int marqueeBehavior = DEFAULT_MARQUEE_BEHAVIOR;
    private Figure marqueeRectangleFigure;
    private int mode;
    private Collection selectedEditParts;
    private Request targetRequest;

    public MarqueeSelectionTool() {
        this.setDefaultCursor(SharedCursors.CROSS);
        this.setUnloadWhenFinished(false);
    }

    protected void applyProperty(Object key, Object value) {
        if (PROPERTY_MARQUEE_BEHAVIOR.equals(key)) {
            if (value instanceof Integer) {
                this.setMarqueeBehavior((Integer)value);
            }
            return;
        }
        super.applyProperty(key, value);
    }

    protected Collection calculateMarqueeSelectedEditParts() {
        HashSet marqueeSelectedEditParts = new HashSet();
        marqueeSelectedEditParts.addAll(this.calculatePrimaryMarqueeSelectedEditParts());
        marqueeSelectedEditParts.addAll(this.calculateSecondaryMarqueeSelectedEditParts(marqueeSelectedEditParts));
        return marqueeSelectedEditParts;
    }

    private Collection calculatePrimaryMarqueeSelectedEditParts() {
        HashSet editPartsToProcess = new HashSet();
        if (this.marqueeBehavior != BEHAVIOR_CONNECTIONS_CONTAINED && this.marqueeBehavior != BEHAVIOR_CONNECTIONS_TOUCHED) {
            editPartsToProcess.addAll(EditPartUtilities.getAllChildren((GraphicalEditPart)((Object)this.getCurrentViewer().getRootEditPart())));
        }
        if (this.marqueeBehavior != BEHAVIOR_NODES_CONTAINED && this.marqueeBehavior != BEHAVIOR_NODES_TOUCHED) {
            editPartsToProcess.addAll(EditPartUtilities.getAllNestedConnectionEditParts((GraphicalEditPart)((Object)this.getCurrentViewer().getRootEditPart())));
        }
        ArrayList<GraphicalEditPart> marqueeSelectedEditParts = new ArrayList<GraphicalEditPart>();
        Iterator iterator = editPartsToProcess.iterator();
        while (iterator.hasNext()) {
            GraphicalEditPart editPart = (GraphicalEditPart)iterator.next();
            if (!this.isMarqueeSelectable(editPart) || !this.isPrimaryMarqueeSelectedEditPart(editPart)) continue;
            marqueeSelectedEditParts.add(editPart);
        }
        return marqueeSelectedEditParts;
    }

    private Collection calculateSecondaryMarqueeSelectedEditParts(Collection directlyMarqueeSelectedEditParts) {
        HashSet editPartsToProcess = new HashSet();
        Iterator iterator = directlyMarqueeSelectedEditParts.iterator();
        while (iterator.hasNext()) {
            GraphicalEditPart marqueeSelectedEditPart = (GraphicalEditPart)iterator.next();
            editPartsToProcess.addAll(marqueeSelectedEditPart.getSourceConnections());
            editPartsToProcess.addAll(marqueeSelectedEditPart.getTargetConnections());
        }
        HashSet<GraphicalEditPart> secondaryMarqueeSelectedEditParts = new HashSet<GraphicalEditPart>();
        Iterator iterator2 = editPartsToProcess.iterator();
        while (iterator2.hasNext()) {
            GraphicalEditPart editPart = (GraphicalEditPart)iterator2.next();
            if (!this.isSecondaryMarqueeSelectedEditPart(directlyMarqueeSelectedEditParts, editPart)) continue;
            secondaryMarqueeSelectedEditParts.add(editPart);
        }
        return secondaryMarqueeSelectedEditParts;
    }

    private Request createTargetRequest() {
        return MARQUEE_REQUEST;
    }

    public void deactivate() {
        if (this.isInState(4)) {
            this.eraseMarqueeFeedback();
            this.eraseTargetFeedback();
        }
        super.deactivate();
        this.allChildren.clear();
        this.setState(0x40000000);
    }

    private void eraseMarqueeFeedback() {
        if (this.marqueeRectangleFigure != null) {
            this.removeFeedback((IFigure)this.marqueeRectangleFigure);
            this.marqueeRectangleFigure = null;
        }
    }

    private void eraseTargetFeedback() {
        if (this.selectedEditParts == null) {
            return;
        }
        Iterator oldEditParts = this.selectedEditParts.iterator();
        while (oldEditParts.hasNext()) {
            EditPart editPart = (EditPart)oldEditParts.next();
            editPart.eraseTargetFeedback(this.getTargetRequest());
        }
    }

    protected String getCommandName() {
        return "selection";
    }

    protected Rectangle getCurrentMarqueeSelectionRectangle() {
        return new Rectangle(this.getStartLocation(), this.getLocation());
    }

    protected int getCurrentSelectionMode() {
        return this.mode;
    }

    protected String getDebugName() {
        return "Marquee Tool: " + this.marqueeBehavior;
    }

    private IFigure getMarqueeFeedbackFigure() {
        if (this.marqueeRectangleFigure == null) {
            this.marqueeRectangleFigure = new MarqueeRectangleFigure();
            this.addFeedback((IFigure)this.marqueeRectangleFigure);
        }
        return this.marqueeRectangleFigure;
    }

    private Request getTargetRequest() {
        if (this.targetRequest == null) {
            this.targetRequest = this.createTargetRequest();
        }
        return this.targetRequest;
    }

    protected boolean handleButtonDown(int button) {
        if (!this.isCurrentViewerGraphical()) {
            return true;
        }
        if (button != 1) {
            this.setState(8);
            this.handleInvalidInput();
        }
        if (this.stateTransition(1, 4)) {
            if (this.getCurrentInput().isModKeyDown(SWT.MOD1)) {
                this.setSelectionMode(1);
            } else if (this.getCurrentInput().isShiftKeyDown()) {
                this.setSelectionMode(2);
            } else {
                this.setSelectionMode(0);
            }
        }
        return true;
    }

    protected boolean handleButtonUp(int button) {
        if (this.stateTransition(4, 0x40000000)) {
            this.eraseTargetFeedback();
            this.eraseMarqueeFeedback();
            this.performMarqueeSelect();
        }
        this.handleFinished();
        return true;
    }

    protected boolean handleDragInProgress() {
        if (this.isInState(6)) {
            this.showMarqueeFeedback();
            this.eraseTargetFeedback();
            this.selectedEditParts = this.calculateMarqueeSelectedEditParts();
            this.showTargetFeedback();
        }
        return true;
    }

    protected boolean handleFocusLost() {
        if (this.isInState(6)) {
            this.handleFinished();
            return true;
        }
        return false;
    }

    protected boolean handleInvalidInput() {
        this.eraseTargetFeedback();
        this.eraseMarqueeFeedback();
        return true;
    }

    protected boolean handleKeyDown(KeyEvent e) {
        if (super.handleKeyDown(e)) {
            return true;
        }
        if (this.getCurrentViewer().getKeyHandler() != null) {
            return this.getCurrentViewer().getKeyHandler().keyPressed(e);
        }
        return false;
    }

    protected boolean isMarqueeSelectable(GraphicalEditPart editPart) {
        return editPart.getTargetEditPart(MARQUEE_REQUEST) == editPart && editPart.isSelectable() && FigureUtilities.isNotFullyClipped((IFigure)editPart.getFigure());
    }

    private boolean isPrimaryMarqueeSelectedEditPart(GraphicalEditPart editPart) {
        IFigure figure = editPart.getFigure();
        Rectangle r = figure.getBounds().getCopy();
        figure.translateToAbsolute((Translatable)r);
        boolean included = false;
        Rectangle marqueeSelectionRectangle = this.getCurrentMarqueeSelectionRectangle();
        if (editPart instanceof ConnectionEditPart) {
            if ((this.marqueeBehavior == BEHAVIOR_CONNECTIONS_TOUCHED || this.marqueeBehavior == BEHAVIOR_CONNECTIONS_CONTAINED) && marqueeSelectionRectangle.intersects(r)) {
                Rectangle relMarqueeRect = Rectangle.SINGLETON;
                figure.translateToRelative((Translatable)relMarqueeRect.setBounds(marqueeSelectionRectangle));
                if (this.marqueeBehavior == BEHAVIOR_CONNECTIONS_TOUCHED) {
                    included = ((Connection)figure).getPoints().intersects(relMarqueeRect);
                } else if (this.marqueeBehavior == BEHAVIOR_CONNECTIONS_CONTAINED) {
                    included = relMarqueeRect.contains(((Connection)figure).getPoints().getBounds());
                }
            }
        } else if (this.marqueeBehavior == BEHAVIOR_NODES_TOUCHED || this.marqueeBehavior == BEHAVIOR_NODES_TOUCHED_AND_RELATED_CONNECTIONS) {
            included = marqueeSelectionRectangle.intersects(r);
        } else if (this.marqueeBehavior == BEHAVIOR_NODES_CONTAINED || this.marqueeBehavior == BEHAVIOR_NODES_CONTAINED_AND_RELATED_CONNECTIONS) {
            included = marqueeSelectionRectangle.contains(r);
        }
        return included;
    }

    private boolean isSecondaryMarqueeSelectedEditPart(Collection directlyMarqueeSelectedEditParts, EditPart editPart) {
        boolean included = false;
        if (editPart instanceof ConnectionEditPart && (this.marqueeBehavior == BEHAVIOR_NODES_CONTAINED_AND_RELATED_CONNECTIONS || this.marqueeBehavior == BEHAVIOR_NODES_TOUCHED_AND_RELATED_CONNECTIONS)) {
            ConnectionEditPart connection = (ConnectionEditPart)editPart;
            GraphicalEditPart source = (GraphicalEditPart)connection.getSource();
            GraphicalEditPart target = (GraphicalEditPart)connection.getTarget();
            boolean sourceIncludedInMarqueeSelection = directlyMarqueeSelectedEditParts.contains(source);
            boolean targetIncludedInMarqueeSelection = directlyMarqueeSelectedEditParts.contains(target);
            if (this.mode == 0) {
                included = sourceIncludedInMarqueeSelection && targetIncludedInMarqueeSelection;
            } else if (this.mode == 2) {
                included = !(connection.getSelected() != 0 || !this.getCurrentViewer().getSelectedEditParts().contains(source) && !sourceIncludedInMarqueeSelection || !this.getCurrentViewer().getSelectedEditParts().contains(target) && !targetIncludedInMarqueeSelection);
            } else if (this.mode == 1) {
                included = connection.getSelected() == 0 ? (source.getSelected() == 0 && sourceIncludedInMarqueeSelection || source.getSelected() != 0 && !sourceIncludedInMarqueeSelection) && (target.getSelected() == 0 && targetIncludedInMarqueeSelection || target.getSelected() != 0 && !targetIncludedInMarqueeSelection) : source.getSelected() != 0 && sourceIncludedInMarqueeSelection || target.getSelected() != 0 && targetIncludedInMarqueeSelection;
            }
        }
        return included;
    }

    protected boolean isViewerImportant(EditPartViewer viewer) {
        return this.isCurrentViewerGraphical();
    }

    private boolean isCurrentViewerGraphical() {
        return this.getCurrentViewer() instanceof GraphicalViewer;
    }

    protected void performMarqueeSelect() {
        Collection marqueeSelectedEditParts = this.calculateMarqueeSelectedEditParts();
        LinkedHashSet<EditPart> editPartsToSelect = new LinkedHashSet<EditPart>();
        HashSet<EditPart> editPartsToDeselect = new HashSet<EditPart>();
        Iterator iterator = marqueeSelectedEditParts.iterator();
        while (iterator.hasNext()) {
            EditPart affectedEditPart = (EditPart)iterator.next();
            if (affectedEditPart.getSelected() == 0 || this.getCurrentSelectionMode() != 1) {
                editPartsToSelect.add(affectedEditPart);
                continue;
            }
            editPartsToDeselect.add(affectedEditPart);
        }
        if (this.getCurrentSelectionMode() != 0) {
            editPartsToSelect.addAll(this.getCurrentViewer().getSelectedEditParts());
            editPartsToSelect.removeAll(editPartsToDeselect);
        }
        this.getCurrentViewer().setSelection((ISelection)new StructuredSelection(editPartsToSelect.toArray()));
    }

    public void setMarqueeBehavior(int type) {
        if (type != BEHAVIOR_CONNECTIONS_TOUCHED && type != BEHAVIOR_CONNECTIONS_CONTAINED && type != BEHAVIOR_NODES_TOUCHED && type != BEHAVIOR_NODES_TOUCHED_AND_RELATED_CONNECTIONS && type != BEHAVIOR_NODES_CONTAINED && type != BEHAVIOR_NODES_CONTAINED_AND_RELATED_CONNECTIONS) {
            throw new IllegalArgumentException("Invalid marquee behaviour specified.");
        }
        this.marqueeBehavior = type;
    }

    private void setSelectionMode(int mode) {
        this.mode = mode;
    }

    public void setViewer(EditPartViewer viewer) {
        if (viewer == this.getCurrentViewer()) {
            return;
        }
        super.setViewer(viewer);
        if (viewer instanceof GraphicalViewer) {
            this.setDefaultCursor(SharedCursors.CROSS);
        } else {
            this.setDefaultCursor(SharedCursors.NO);
        }
    }

    private void showMarqueeFeedback() {
        Rectangle rect = this.getCurrentMarqueeSelectionRectangle().getCopy();
        IFigure marqueeFeedbackFigure = this.getMarqueeFeedbackFigure();
        marqueeFeedbackFigure.translateToRelative((Translatable)rect);
        marqueeFeedbackFigure.setBounds(rect);
        marqueeFeedbackFigure.validate();
    }

    private void showTargetFeedback() {
        Iterator itr = this.selectedEditParts.iterator();
        while (itr.hasNext()) {
            EditPart editPart = (EditPart)itr.next();
            editPart.showTargetFeedback(this.getTargetRequest());
        }
    }

    class MarqueeRectangleFigure
    extends Figure {
        private static final int DELAY = 110;
        private int offset = 0;
        private boolean schedulePaint = true;

        MarqueeRectangleFigure() {
        }

        protected void paintFigure(Graphics graphics) {
            Rectangle bounds = this.getBounds().getCopy();
            graphics.translate(this.getLocation());
            graphics.setXORMode(true);
            graphics.setForegroundColor(ColorConstants.white);
            graphics.setBackgroundColor(ColorConstants.black);
            graphics.setLineStyle(3);
            int[] points = new int[]{0 + this.offset, 0, bounds.width - 1, 0, bounds.width - 1, bounds.height - 1};
            graphics.drawPolyline(points);
            points[0] = 0;
            points[1] = 0 + this.offset;
            points[2] = 0;
            points[3] = bounds.height - 1;
            points[4] = bounds.width - 1;
            points[5] = bounds.height - 1;
            graphics.drawPolyline(points);
            graphics.translate(this.getLocation().getNegated());
            if (this.schedulePaint) {
                Display.getCurrent().timerExec(110, new Runnable(this){
                    final /* synthetic */ MarqueeRectangleFigure this$1;
                    {
                        this.this$1 = marqueeRectangleFigure;
                    }

                    public void run() {
                        MarqueeRectangleFigure marqueeRectangleFigure = this.this$1;
                        MarqueeRectangleFigure.access$1(marqueeRectangleFigure, MarqueeRectangleFigure.access$0(marqueeRectangleFigure) + 1);
                        if (MarqueeRectangleFigure.access$0(this.this$1) > 5) {
                            MarqueeRectangleFigure.access$1(this.this$1, 0);
                        }
                        MarqueeRectangleFigure.access$2(this.this$1, true);
                        this.this$1.repaint();
                    }
                });
            }
            this.schedulePaint = false;
        }

        static /* synthetic */ int access$0(MarqueeRectangleFigure marqueeRectangleFigure) {
            return marqueeRectangleFigure.offset;
        }

        static /* synthetic */ void access$1(MarqueeRectangleFigure marqueeRectangleFigure, int n) {
            marqueeRectangleFigure.offset = n;
        }

        static /* synthetic */ void access$2(MarqueeRectangleFigure marqueeRectangleFigure, boolean bl) {
            marqueeRectangleFigure.schedulePaint = bl;
        }
    }
}

