/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.InterruptibleVisitor;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.PrimitiveRatherThanWrapperOperation;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

public abstract class AbstractPrimitiveRatherThanWrapperFinder
extends ASTVisitor {
    protected List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> fResult;

    public abstract String getPrimitiveTypeName();

    public abstract Class<? extends Expression> getLiteralClass();

    public String getWrapperFullyQualifiedName() {
        return Bindings.getBoxedTypeName(this.getPrimitiveTypeName());
    }

    public List<PrefixExpression.Operator> getPrefixInSafeOperators() {
        return new ArrayList<PrefixExpression.Operator>(0);
    }

    public List<InfixExpression.Operator> getInfixInSafeOperators() {
        return Collections.emptyList();
    }

    public List<PostfixExpression.Operator> getPostfixInSafeOperators() {
        return Collections.emptyList();
    }

    public List<PrefixExpression.Operator> getPrefixOutSafeOperators() {
        return Collections.emptyList();
    }

    public List<InfixExpression.Operator> getInfixOutSafeOperators() {
        return Collections.emptyList();
    }

    public List<PostfixExpression.Operator> getPostfixOutSafeOperators() {
        return Collections.emptyList();
    }

    public List<Assignment.Operator> getAssignmentOutSafeOperators() {
        return Collections.emptyList();
    }

    public String[] getSafeInConstants() {
        return new String[0];
    }

    public boolean isSpecificPrimitiveAllowed(ASTNode node) {
        return false;
    }

    public boolean visit(VariableDeclarationStatement visited) {
        VariableDeclarationFragment fragment = ASTNodes.getUniqueFragment((Statement)visited);
        if (fragment != null && fragment.getInitializer() != null && (this.isNotNull(fragment.getInitializer()) || this.canReturnPrimitiveInstead(fragment.getInitializer())) && (fragment.resolveBinding() != null && ASTNodes.hasType(fragment.resolveBinding().getType(), this.getWrapperFullyQualifiedName()) || visited.getType() != null && visited.getType().resolveBinding() != null && ASTNodes.hasType(visited.getType().resolveBinding(), this.getWrapperFullyQualifiedName()))) {
            VarOccurrenceVisitor varOccurrenceVisitor = new VarOccurrenceVisitor(fragment);
            Block parentBlock = ASTNodes.getTypedAncestor((ASTNode)fragment, Block.class);
            if (parentBlock != null) {
                varOccurrenceVisitor.traverseNodeInterruptibly((ASTNode)parentBlock);
                int boxingCount = varOccurrenceVisitor.getAutoBoxingCount();
                if (ASTNodes.hasType(fragment.getInitializer(), this.getWrapperFullyQualifiedName()) && !this.canReturnPrimitiveInstead(fragment.getInitializer())) {
                    ++boxingCount;
                }
                if (varOccurrenceVisitor.isPrimitiveAllowed() && boxingCount < 2) {
                    this.fResult.add(new PrimitiveRatherThanWrapperOperation(visited, this.getPrimitiveTypeName(), this.getWrapperFullyQualifiedName(), fragment.getInitializer(), varOccurrenceVisitor.getToStringMethods(), varOccurrenceVisitor.getCompareToMethods(), varOccurrenceVisitor.getPrimitiveValueMethods(), this.getParsingMethodName(this.getWrapperFullyQualifiedName(), (CompilationUnit)visited.getRoot())));
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isNotNull(Expression expression) {
        ClassInstanceCreation classInstanceCreation;
        List classInstanceCreationArguments;
        if (expression instanceof ParenthesizedExpression) {
            ParenthesizedExpression parenthesizedExpression = (ParenthesizedExpression)expression;
            return this.isNotNull(parenthesizedExpression.getExpression());
        }
        if (expression instanceof ConditionalExpression) {
            ConditionalExpression prefixExpression = (ConditionalExpression)expression;
            return this.isNotNull(prefixExpression.getThenExpression()) && this.isNotNull(prefixExpression.getElseExpression());
        }
        if (this.getLiteralClass().equals(expression.getClass())) {
            return true;
        }
        if (expression instanceof QualifiedName) {
            QualifiedName qualifiedName = (QualifiedName)expression;
            return ASTNodes.hasType((Expression)qualifiedName.getQualifier(), this.getWrapperFullyQualifiedName()) && (ASTNodes.isField(qualifiedName, this.getWrapperFullyQualifiedName(), this.getSafeInConstants()) || ASTNodes.isField(qualifiedName, this.getPrimitiveTypeName(), this.getSafeInConstants()));
        }
        if (expression instanceof InfixExpression) {
            InfixExpression infixExpression = (InfixExpression)expression;
            return this.getInfixInSafeOperators().contains(infixExpression.getOperator());
        }
        if (expression instanceof PrefixExpression) {
            PrefixExpression prefixExpression = (PrefixExpression)expression;
            return this.getPrefixInSafeOperators().contains(prefixExpression.getOperator());
        }
        if (expression instanceof PostfixExpression) {
            PostfixExpression postfixExpression = (PostfixExpression)expression;
            return this.getPostfixInSafeOperators().contains(postfixExpression.getOperator());
        }
        if (expression instanceof CastExpression) {
            CastExpression castExpression = (CastExpression)expression;
            return ASTNodes.hasType(castExpression.getType().resolveBinding(), this.getPrimitiveTypeName()) || ASTNodes.hasType(castExpression.getType().resolveBinding(), this.getWrapperFullyQualifiedName()) && this.isNotNull(castExpression.getExpression());
        }
        if (expression instanceof ClassInstanceCreation && (classInstanceCreationArguments = (classInstanceCreation = (ClassInstanceCreation)expression).arguments()).size() == 1) {
            Expression arg0 = (Expression)classInstanceCreationArguments.get(0);
            return ASTNodes.hasType(arg0, String.class.getCanonicalName());
        }
        return false;
    }

    private boolean canReturnPrimitiveInstead(Expression expression) {
        List classInstanceCreationArguments;
        MethodInvocation methodInvocation = ASTNodes.as(expression, MethodInvocation.class);
        if (methodInvocation != null) {
            return ASTNodes.usesGivenSignature(methodInvocation, this.getWrapperFullyQualifiedName(), "valueOf", this.getPrimitiveTypeName()) || this.getParsingMethodName(this.getWrapperFullyQualifiedName(), (CompilationUnit)expression.getRoot()) != null && (ASTNodes.usesGivenSignature(methodInvocation, this.getWrapperFullyQualifiedName(), "valueOf", String.class.getCanonicalName()) || ASTNodes.usesGivenSignature(methodInvocation, this.getWrapperFullyQualifiedName(), "valueOf", String.class.getCanonicalName(), Integer.TYPE.getSimpleName()));
        }
        ClassInstanceCreation classInstanceCreation = ASTNodes.as(expression, ClassInstanceCreation.class);
        if (classInstanceCreation != null && (classInstanceCreationArguments = classInstanceCreation.arguments()).size() == 1) {
            Expression arg0 = (Expression)classInstanceCreationArguments.get(0);
            return ASTNodes.hasType(arg0, String.class.getCanonicalName());
        }
        return false;
    }

    private String getParsingMethodName(String wrapperFullyQualifiedName, CompilationUnit compilationUnit) {
        if (Boolean.class.getCanonicalName().equals(wrapperFullyQualifiedName) && JavaModelUtil.is50OrHigher(compilationUnit.getJavaElement().getJavaProject())) {
            return "parseBoolean";
        }
        if (Integer.class.getCanonicalName().equals(wrapperFullyQualifiedName)) {
            return "parseInt";
        }
        if (Long.class.getCanonicalName().equals(wrapperFullyQualifiedName)) {
            return "parseLong";
        }
        if (Double.class.getCanonicalName().equals(wrapperFullyQualifiedName) && JavaModelUtil.is1d2OrHigher(compilationUnit.getJavaElement().getJavaProject())) {
            return "parseDouble";
        }
        if (Float.class.getCanonicalName().equals(wrapperFullyQualifiedName) && JavaModelUtil.is1d2OrHigher(compilationUnit.getJavaElement().getJavaProject())) {
            return "parseFloat";
        }
        if (Short.class.getCanonicalName().equals(wrapperFullyQualifiedName)) {
            return "parseShort";
        }
        if (Byte.class.getCanonicalName().equals(wrapperFullyQualifiedName)) {
            return "parseByte";
        }
        return null;
    }

    private class VarOccurrenceVisitor
    extends InterruptibleVisitor {
        private final VariableDeclarationFragment varDecl;
        private final List<MethodInvocation> toStringMethods = new ArrayList<MethodInvocation>();
        private final List<MethodInvocation> compareToMethods = new ArrayList<MethodInvocation>();
        private final List<MethodInvocation> primitiveValueMethods = new ArrayList<MethodInvocation>();
        private boolean isPrimitiveAllowed = true;
        private boolean isVarReturned;
        private int autoBoxingCount;

        public VarOccurrenceVisitor(VariableDeclarationFragment var) {
            this.varDecl = var;
        }

        public List<MethodInvocation> getToStringMethods() {
            return this.toStringMethods;
        }

        public List<MethodInvocation> getCompareToMethods() {
            return this.compareToMethods;
        }

        public List<MethodInvocation> getPrimitiveValueMethods() {
            return this.primitiveValueMethods;
        }

        public boolean isPrimitiveAllowed() {
            return this.isPrimitiveAllowed;
        }

        public int getAutoBoxingCount() {
            return this.autoBoxingCount;
        }

        public boolean visit(SimpleName aVar) {
            if (this.isPrimitiveAllowed && ASTNodes.isSameVariable((ASTNode)aVar, (ASTNode)this.varDecl.getName()) && !aVar.getParent().equals((Object)this.varDecl)) {
                this.isPrimitiveAllowed = this.isPrimitiveAllowed((ASTNode)aVar);
                if (!this.isPrimitiveAllowed) {
                    return this.interruptVisit();
                }
            }
            return true;
        }

        private boolean isPrimitiveAllowed(ASTNode node) {
            ASTNode parentNode = node.getParent();
            switch (parentNode.getNodeType()) {
                case 36: {
                    return this.isPrimitiveAllowed(parentNode);
                }
                case 11: {
                    CastExpression castExpression = (CastExpression)parentNode;
                    return ASTNodes.hasType(castExpression.getType().resolveBinding(), AbstractPrimitiveRatherThanWrapperFinder.this.getPrimitiveTypeName());
                }
                case 7: {
                    Assignment assignment = (Assignment)parentNode;
                    if (AbstractPrimitiveRatherThanWrapperFinder.this.getAssignmentOutSafeOperators().contains(assignment.getOperator())) {
                        return true;
                    }
                    if (assignment.getLeftHandSide().equals((Object)node)) {
                        return AbstractPrimitiveRatherThanWrapperFinder.this.isNotNull(assignment.getRightHandSide());
                    }
                    if (assignment.getRightHandSide().equals((Object)node)) {
                        if (assignment.getLeftHandSide() instanceof Name) {
                            return this.isOfType(((Name)assignment.getLeftHandSide()).resolveTypeBinding());
                        }
                        if (assignment.getLeftHandSide() instanceof FieldAccess) {
                            return this.isOfType(((FieldAccess)assignment.getLeftHandSide()).resolveTypeBinding());
                        }
                        if (assignment.getLeftHandSide() instanceof SuperFieldAccess) {
                            return this.isOfType(((SuperFieldAccess)assignment.getLeftHandSide()).resolveTypeBinding());
                        }
                    }
                    return false;
                }
                case 59: {
                    VariableDeclarationFragment fragment = (VariableDeclarationFragment)parentNode;
                    return node.getLocationInParent() == VariableDeclarationFragment.INITIALIZER_PROPERTY && this.isOfType(fragment.getName().resolveTypeBinding());
                }
                case 41: {
                    MethodDeclaration method;
                    if (node.getLocationInParent() == ReturnStatement.EXPRESSION_PROPERTY && (method = ASTNodes.getTypedAncestor(parentNode, MethodDeclaration.class)) != null && method.getReturnType2() != null) {
                        if (ASTNodes.hasType(method.getReturnType2().resolveBinding(), AbstractPrimitiveRatherThanWrapperFinder.this.getPrimitiveTypeName())) {
                            return true;
                        }
                        if (ASTNodes.hasType(method.getReturnType2().resolveBinding(), AbstractPrimitiveRatherThanWrapperFinder.this.getWrapperFullyQualifiedName())) {
                            if (!this.isVarReturned) {
                                this.isVarReturned = true;
                                ++this.autoBoxingCount;
                            }
                            return true;
                        }
                    }
                    return false;
                }
                case 16: {
                    return node.getLocationInParent() == ConditionalExpression.EXPRESSION_PROPERTY;
                }
                case 38: {
                    return AbstractPrimitiveRatherThanWrapperFinder.this.getPrefixOutSafeOperators().contains(((PrefixExpression)parentNode).getOperator());
                }
                case 27: {
                    return AbstractPrimitiveRatherThanWrapperFinder.this.getInfixOutSafeOperators().contains(((InfixExpression)parentNode).getOperator());
                }
                case 37: {
                    return AbstractPrimitiveRatherThanWrapperFinder.this.getPostfixOutSafeOperators().contains(((PostfixExpression)parentNode).getOperator());
                }
                case 32: {
                    MethodInvocation methodInvocation = (MethodInvocation)parentNode;
                    if (node.getLocationInParent() != MethodInvocation.EXPRESSION_PROPERTY) break;
                    if (ASTNodes.usesGivenSignature(methodInvocation, AbstractPrimitiveRatherThanWrapperFinder.this.getWrapperFullyQualifiedName(), String.valueOf(AbstractPrimitiveRatherThanWrapperFinder.this.getPrimitiveTypeName()) + "Value", new String[0])) {
                        this.primitiveValueMethods.add(methodInvocation);
                        return true;
                    }
                    if (ASTNodes.usesGivenSignature(methodInvocation, AbstractPrimitiveRatherThanWrapperFinder.this.getWrapperFullyQualifiedName(), "toString", new String[0])) {
                        this.toStringMethods.add(methodInvocation);
                        return true;
                    }
                    if (!ASTNodes.usesGivenSignature(methodInvocation, AbstractPrimitiveRatherThanWrapperFinder.this.getWrapperFullyQualifiedName(), "compareTo", AbstractPrimitiveRatherThanWrapperFinder.this.getWrapperFullyQualifiedName())) break;
                    if (ASTNodes.hasType((Expression)methodInvocation.arguments().get(0), AbstractPrimitiveRatherThanWrapperFinder.this.getWrapperFullyQualifiedName())) {
                        ++this.autoBoxingCount;
                    }
                    this.compareToMethods.add(methodInvocation);
                    return true;
                }
            }
            return AbstractPrimitiveRatherThanWrapperFinder.this.isSpecificPrimitiveAllowed(node);
        }

        private boolean isOfType(ITypeBinding resolveTypeBinding) {
            if (ASTNodes.hasType(resolveTypeBinding, AbstractPrimitiveRatherThanWrapperFinder.this.getPrimitiveTypeName())) {
                return true;
            }
            if (ASTNodes.hasType(resolveTypeBinding, AbstractPrimitiveRatherThanWrapperFinder.this.getWrapperFullyQualifiedName())) {
                ++this.autoBoxingCount;
                return true;
            }
            return false;
        }
    }
}

