/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListTagCommand;
import org.eclipse.jgit.api.TagCommand;
import org.eclipse.jgit.api.VerificationResult;
import org.eclipse.jgit.api.VerifySignatureCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.GpgSignatureVerifier;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.pgm.internal.VerificationUtils;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_CreateATag")
class Tag
extends TextBuiltin {
    @Option(name="--force", aliases={"-f"}, forbids={"--delete", "--verify"}, usage="usage_forceReplacingAnExistingTag")
    private boolean force;
    @Option(name="--delete", aliases={"-d"}, forbids={"--verify"}, usage="usage_tagDelete")
    private boolean delete;
    @Option(name="--annotate", aliases={"-a"}, forbids={"--delete", "--verify"}, usage="usage_tagAnnotated")
    private boolean annotated;
    @Option(name="-m", forbids={"--delete", "--verify"}, metaVar="metaVar_message", usage="usage_tagMessage")
    private String message;
    @Option(name="--sign", aliases={"-s"}, forbids={"--no-sign", "--delete", "--verify"}, usage="usage_tagSign")
    private boolean sign;
    @Option(name="--no-sign", usage="usage_tagNoSign", forbids={"--sign", "--delete", "--verify"})
    private boolean noSign;
    @Option(name="--local-user", aliases={"-u"}, forbids={"--delete", "--verify"}, metaVar="metaVar_tagLocalUser", usage="usage_tagLocalUser")
    private String gpgKeyId;
    @Option(name="--verify", aliases={"-v"}, forbids={"--delete", "--force", "--annotate", "-m", "--sign", "--no-sign", "--local-user"}, usage="usage_tagVerify")
    private boolean verify;
    @Argument(index=0, metaVar="metaVar_name")
    private String tagName;
    @Argument(index=1, metaVar="metaVar_object")
    private ObjectId object;

    Tag() {
    }

    @Override
    protected void run() {
        block37: {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (Git git = new Git(this.db);){
                    if (this.tagName != null) {
                        if (this.verify) {
                            VerifySignatureCommand verifySig = git.verifySignature().setMode(VerifySignatureCommand.VerifyMode.TAGS).addName(this.tagName);
                            VerificationResult verification = (VerificationResult)verifySig.call().get(this.tagName);
                            if (verification == null) {
                                this.showUnsigned(git, this.tagName);
                            } else {
                                Throwable error22 = verification.getException();
                                if (error22 != null) {
                                    throw Tag.die(error22.getMessage(), error22);
                                }
                                this.writeVerification(verifySig.getVerifier().getName(), (RevTag)verification.getObject(), verification.getVerification());
                            }
                            break block37;
                        }
                        if (this.delete) {
                            List deletedTags = git.tagDelete().setTags(new String[]{this.tagName}).call();
                            if (deletedTags.isEmpty()) {
                                throw Tag.die(MessageFormat.format(CLIText.get().tagNotFound, this.tagName));
                            }
                            break block37;
                        }
                        TagCommand command = git.tag().setForceUpdate(this.force).setMessage(this.message).setName(this.tagName);
                        if (this.object != null) {
                            Throwable verification = null;
                            Object error22 = null;
                            try (RevWalk walk = new RevWalk(this.db);){
                                command.setObjectId(walk.parseAny((AnyObjectId)this.object));
                            }
                            catch (Throwable error22) {
                                if (verification == null) {
                                    verification = error22;
                                } else if (verification != error22) {
                                    verification.addSuppressed(error22);
                                }
                                throw verification;
                            }
                        }
                        if (this.noSign) {
                            command.setSigned(false);
                        } else if (this.sign) {
                            command.setSigned(true);
                        }
                        if (this.annotated) {
                            command.setAnnotated(true);
                        } else if (this.message == null && !this.sign && this.gpgKeyId == null) {
                            command.setAnnotated(false);
                        }
                        command.setSigningKey(this.gpgKeyId);
                        try {
                            command.call();
                            break block37;
                        }
                        catch (RefAlreadyExistsException e) {
                            throw Tag.die(MessageFormat.format(CLIText.get().tagAlreadyExists, this.tagName), (Throwable)e);
                        }
                    }
                    ListTagCommand command = git.tagList();
                    List list = command.call();
                    for (Ref ref : list) {
                        this.outw.println(Repository.shortenRefName((String)ref.getName()));
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | GitAPIException e) {
                throw Tag.die(e.getMessage(), e);
            }
        }
    }

    private void showUnsigned(Git git, String wantedTag) throws IOException {
        block10: {
            ObjectId id = git.getRepository().resolve(wantedTag);
            if (id != null && !ObjectId.zeroId().equals((AnyObjectId)id)) {
                Throwable throwable = null;
                Object var5_6 = null;
                try (RevWalk walk = new RevWalk(git.getRepository());){
                    this.showTag(walk.parseTag((AnyObjectId)id));
                    break block10;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            throw Tag.die(MessageFormat.format(CLIText.get().tagNotFound, wantedTag));
        }
    }

    private void showTag(RevTag tag) throws IOException {
        this.outw.println("object " + tag.getObject().name());
        this.outw.println("type " + Constants.typeString((int)tag.getObject().getType()));
        this.outw.println("tag " + tag.getTagName());
        this.outw.println("tagger " + tag.getTaggerIdent().toExternalString());
        this.outw.println();
        this.outw.print((Object)tag.getFullMessage());
    }

    private void writeVerification(String name, RevTag tag, GpgSignatureVerifier.SignatureVerification verification) throws IOException {
        this.showTag(tag);
        if (verification == null) {
            this.outw.println();
            return;
        }
        VerificationUtils.writeVerification(this.outw, verification, name, tag.getTaggerIdent());
    }
}

