/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm.opt;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.pgm.Die;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.pgm.opt.AbstractTreeIteratorHandler;
import org.eclipse.jgit.pgm.opt.ObjectIdHandler;
import org.eclipse.jgit.pgm.opt.OptionWithValuesListHandler;
import org.eclipse.jgit.pgm.opt.PathTreeFilterHandler;
import org.eclipse.jgit.pgm.opt.RefSpecHandler;
import org.eclipse.jgit.pgm.opt.RevCommitHandler;
import org.eclipse.jgit.pgm.opt.RevTreeHandler;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.NamedOptionDef;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.OptionHandlerRegistry;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.RestOfArgumentsHandler;
import org.kohsuke.args4j.spi.Setter;

public class CmdLineParser
extends org.kohsuke.args4j.CmdLineParser {
    private final Repository db;
    private RevWalk walk;
    private boolean seenHelp;
    private TextBuiltin cmd;

    static {
        OptionHandlerRegistry registry = OptionHandlerRegistry.getRegistry();
        registry.registerHandler(AbstractTreeIterator.class, AbstractTreeIteratorHandler.class);
        registry.registerHandler(ObjectId.class, ObjectIdHandler.class);
        registry.registerHandler(RefSpec.class, RefSpecHandler.class);
        registry.registerHandler(RevCommit.class, RevCommitHandler.class);
        registry.registerHandler(RevTree.class, RevTreeHandler.class);
        registry.registerHandler(List.class, OptionWithValuesListHandler.class);
    }

    public CmdLineParser(Object bean) {
        this(bean, null);
    }

    public CmdLineParser(Object bean, Repository repo) {
        super(bean);
        if (bean instanceof TextBuiltin) {
            this.cmd = (TextBuiltin)bean;
        }
        if (repo == null && this.cmd != null) {
            repo = this.cmd.getRepository();
        }
        this.db = repo;
    }

    public void parseArgument(String ... args) throws CmdLineException {
        ArrayList<String> tmp = new ArrayList<String>(args.length);
        int argi = 0;
        while (argi < args.length) {
            int eq;
            String str = args[argi];
            if (str.equals("--")) {
                while (argi < args.length) {
                    tmp.add(args[argi++]);
                }
                break;
            }
            if (str.startsWith("--") && (eq = str.indexOf(61)) > 0) {
                tmp.add(str.substring(0, eq));
                tmp.add(str.substring(eq + 1));
            } else {
                tmp.add(str);
                if (this.containsHelp(args)) {
                    this.seenHelp = true;
                    break;
                }
            }
            ++argi;
        }
        List<OptionHandler> backup = null;
        if (this.seenHelp) {
            backup = this.unsetRequiredOptions();
        }
        try {
            try {
                super.parseArgument(tmp.toArray(new String[0]));
            }
            catch (Die e) {
                if (!this.seenHelp) {
                    throw e;
                }
                this.printToErrorWriter(CLIText.fatalError(e.getMessage()));
                if (backup != null && !backup.isEmpty()) {
                    this.restoreRequiredOptions(backup);
                }
                this.seenHelp = false;
            }
        }
        finally {
            if (backup != null && !backup.isEmpty()) {
                this.restoreRequiredOptions(backup);
            }
            this.seenHelp = false;
        }
    }

    private void printToErrorWriter(String error) {
        if (this.cmd == null) {
            System.err.println(error);
        } else {
            try {
                this.cmd.getErrorWriter().println(error);
            }
            catch (IOException e1) {
                System.err.println(error);
            }
        }
    }

    private List<OptionHandler> unsetRequiredOptions() {
        List options = this.getOptions();
        ArrayList<OptionHandler> backup = new ArrayList<OptionHandler>(options);
        Iterator iterator = options.iterator();
        while (iterator.hasNext()) {
            OptionHandler handler = (OptionHandler)iterator.next();
            if (!(handler.option instanceof NamedOptionDef) || !handler.option.required()) continue;
            iterator.remove();
        }
        return backup;
    }

    private void restoreRequiredOptions(List<OptionHandler> backup) {
        List options = this.getOptions();
        options.clear();
        options.addAll(backup);
    }

    protected boolean containsHelp(String ... args) {
        return TextBuiltin.containsHelp(args);
    }

    public Repository getRepository() {
        if (this.db == null) {
            throw new IllegalStateException(CLIText.get().noGitRepositoryConfigured);
        }
        return this.db;
    }

    public RevWalk getRevWalk() {
        if (this.walk == null) {
            this.walk = new RevWalk(this.getRepository());
        }
        return this.walk;
    }

    public RevWalk getRevWalkGently() {
        return this.walk;
    }

    protected OptionHandler createOptionHandler(OptionDef o, Setter setter) {
        if (o instanceof NamedOptionDef) {
            return super.createOptionHandler(o, setter);
        }
        return super.createOptionHandler((OptionDef)new MyOptionDef(o), setter);
    }

    public void printSingleLineUsage(Writer w, ResourceBundle rb) {
        List options = this.getOptions();
        if (options.isEmpty()) {
            super.printSingleLineUsage(w, rb);
            return;
        }
        ArrayList backup = new ArrayList(options);
        boolean changed = this.sortRestOfArgumentsHandlerToTheEnd(options);
        try {
            super.printSingleLineUsage(w, rb);
        }
        finally {
            if (changed) {
                options.clear();
                options.addAll(backup);
            }
        }
    }

    private boolean sortRestOfArgumentsHandlerToTheEnd(List<OptionHandler> options) {
        int i = 0;
        while (i < options.size()) {
            OptionHandler handler = options.get(i);
            if (handler instanceof RestOfArgumentsHandler || handler instanceof PathTreeFilterHandler) {
                options.remove(i);
                options.add(handler);
                return true;
            }
            ++i;
        }
        return false;
    }

    class MyOptionDef
    extends OptionDef {
        public MyOptionDef(OptionDef o) {
            super(o.usage(), o.metaVar(), o.required(), o.help(), o.hidden(), o.handler(), o.isMultiValued());
        }

        public String toString() {
            if (this.metaVar() == null) {
                return "ARG";
            }
            try {
                Field field = CLIText.class.getField(this.metaVar());
                String ret = field.get((Object)CLIText.get()).toString();
                return ret;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                return this.metaVar();
            }
        }

        public boolean required() {
            return CmdLineParser.this.seenHelp ? false : super.required();
        }
    }
}

