/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.GraphicalAddAttributeFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.UpdateAttributeFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.GraphicsUpdater;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorConstants;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;

public class GraphicalRemoveAttributeFeature
extends AbstractCustomFeature {
    public GraphicalRemoveAttributeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public void execute(ICustomContext context) {
        final PictogramElement pe = context.getInnerPictogramElement();
        if (pe == null) {
            return;
        }
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)pe);
        if (ted == null) {
            return;
        }
        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

            protected void doExecute() {
                Shape sh = (Shape)pe;
                Object bo = GraphicalRemoveAttributeFeature.this.getFeatureProvider().getBusinessObjectForPictogramElement((PictogramElement)sh);
                if (bo == null || !PersistentType.class.isInstance(bo)) {
                    return;
                }
                ContainerShape entityShape = (ContainerShape)pe;
                ContainerShape primShape = GraphicsUpdater.getPrimaryShape(entityShape);
                ContainerShape relationShape = GraphicsUpdater.getRelationShape(entityShape);
                ContainerShape basicShape = GraphicsUpdater.getBasicShape(entityShape);
                GraphicalRemoveAttributeFeature.this.removeCompartmentChildren(primShape);
                GraphicalRemoveAttributeFeature.this.removeCompartmentChildren(relationShape);
                GraphicalRemoveAttributeFeature.this.removeCompartmentChildren(basicShape);
                GraphicalRemoveAttributeFeature.this.readdCompartmentsChildren((PersistentType)bo, entityShape, primShape, relationShape, basicShape);
                GraphicalRemoveAttributeFeature.this.layoutPictogramElement((PictogramElement)entityShape);
                GraphicalRemoveAttributeFeature.this.reconnect((PersistentType)bo);
            }
        });
    }

    public void reconnect(PersistentType jpt) {
        JpaArtifactFactory.instance().addNewRelations(this.getFeatureProvider(), jpt);
        JpaArtifactFactory.instance().rearrangeIsARelations(this.getFeatureProvider());
    }

    private void readdCompartmentsChildren(PersistentType persistentType, ContainerShape entityShape, ContainerShape primaryShape, ContainerShape relationShape, ContainerShape basicShape) {
        JPAEditorConstants.DIAGRAM_OBJECT_TYPE dot = JpaArtifactFactory.instance().determineDiagramObjectType(persistentType);
        UpdateAttributeFeature updateFeature = new UpdateAttributeFeature(this.getFeatureProvider());
        updateFeature.addSeparatorsToShape(primaryShape, dot);
        updateFeature.addSeparatorsToShape(relationShape, dot);
        updateFeature.addSeparatorsToShape(basicShape, dot);
        GraphicalAddAttributeFeature graphicalAdd = new GraphicalAddAttributeFeature(this.getFeatureProvider());
        AddContext addContext = new AddContext();
        addContext.setTargetContainer(entityShape);
        for (PersistentAttribute attribute : persistentType.getAttributes()) {
            addContext.setNewObject((Object)attribute);
            graphicalAdd.execute((IContext)addContext);
            this.getFeatureProvider().renewAttributeJoiningStrategyPropertyListener(attribute);
        }
        GraphicsUpdater.updateEntityShape(entityShape);
        this.getFeatureProvider().addJPTForUpdate(persistentType.getName());
    }

    private void removeCompartmentChildren(ContainerShape compartmentShape) {
        Shape shape;
        int y = 0;
        EList children = compartmentShape.getChildren();
        int i = 0;
        while (i < new ArrayList(compartmentShape.getChildren()).size()) {
            shape = (Shape)compartmentShape.getChildren().get(i);
            y = shape.getGraphicsAlgorithm().getY();
            Graphiti.getPeService().deletePictogramElement((PictogramElement)shape);
            ++i;
        }
        i = this.getFeatureProvider().getAttribsNum((Shape)compartmentShape);
        while (i > 0) {
            shape = (Shape)compartmentShape.getChildren().get(i);
            y = shape.getGraphicsAlgorithm().getY();
            Graphiti.getPeService().deletePictogramElement((PictogramElement)shape);
            this.getFeatureProvider().decreaseAttribsNum((Shape)compartmentShape);
            --i;
        }
        children = compartmentShape.getChildren();
        this.shiftUpLowerAttribs(y, (List<Shape>)children);
        compartmentShape.getGraphicsAlgorithm().setHeight(0);
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    private void shiftUpLowerAttribs(int y, List<Shape> children) {
        int i = 0;
        while (i < children.size()) {
            Shape shp = children.get(i);
            if (shp != null) {
                int grY = children.get(i).getGraphicsAlgorithm().getY();
                if (grY > y) {
                    children.get(i).getGraphicsAlgorithm().setY(grY - 20);
                }
                children.get(i).setVisible(false);
                Graphiti.getPeService().deletePictogramElement((PictogramElement)children.get(i));
            }
            ++i;
        }
    }
}

