/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.core.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public final class JavaFacetUtil {
    public static final String FILE_CLASSPATH = ".classpath";
    public static final String FILE_JDT_CORE_PREFS = ".settings/org.eclipse.jdt.core.prefs";
    private static final IPath CPE_PREFIX_FOR_EXEC_ENV = new Path("org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType");
    private static final Map<IProjectFacetVersion, String> FACET_VER_TO_EXEC_ENV = new HashMap<IProjectFacetVersion, String>();

    static {
        FACET_VER_TO_EXEC_ENV.put(JavaFacet.VERSION_1_3, "J2SE-1.3");
        FACET_VER_TO_EXEC_ENV.put(JavaFacet.VERSION_1_4, "J2SE-1.4");
        FACET_VER_TO_EXEC_ENV.put(JavaFacet.VERSION_1_5, "J2SE-1.5");
        FACET_VER_TO_EXEC_ENV.put(JavaFacet.VERSION_1_6, "JavaSE-1.6");
        FACET_VER_TO_EXEC_ENV.put(JavaFacet.VERSION_1_7, "JavaSE-1.7");
        FACET_VER_TO_EXEC_ENV.put(JavaFacet.VERSION_1_8, "JavaSE-1.8");
        FACET_VER_TO_EXEC_ENV.put(JavaFacet.VERSION_9, "JavaSE-9");
        FACET_VER_TO_EXEC_ENV.put(JavaFacet.VERSION_10, "JavaSE-10");
        FACET_VER_TO_EXEC_ENV.put(JavaFacet.VERSION_11, "JavaSE-11");
        FACET_VER_TO_EXEC_ENV.put(JavaFacet.VERSION_12, "JavaSE-12");
        FACET_VER_TO_EXEC_ENV.put(JavaFacet.VERSION_13, "JavaSE-13");
        FACET_VER_TO_EXEC_ENV.put(JavaFacet.VERSION_14, "JavaSE-14");
        FACET_VER_TO_EXEC_ENV.put(JavaFacet.VERSION_15, "JavaSE-15");
        FACET_VER_TO_EXEC_ENV.put(JavaFacet.VERSION_16, "JavaSE-16");
    }

    public static String getCompilerLevel() {
        String level = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance");
        if (level == null) {
            Hashtable defaults = JavaCore.getDefaultOptions();
            level = (String)defaults.get("org.eclipse.jdt.core.compiler.compliance");
        }
        return level;
    }

    public static String getCompilerLevel(IProject project) {
        IJavaProject jproj = JavaCore.create((IProject)project);
        String level = jproj.getOption("org.eclipse.jdt.core.compiler.compliance", false);
        if (level == null) {
            level = JavaFacetUtil.getCompilerLevel();
        }
        return level;
    }

    public static void setCompilerLevel(IProject project, IProjectFacetVersion fv) throws CoreException {
        JavaFacetUtil.setCompilerLevel(project, fv.getVersionString());
    }

    public static void setCompilerLevel(IProject project, String level) throws CoreException {
        IJavaProject jproj = JavaCore.create((IProject)project);
        Map options = jproj.getOptions(false);
        JavaCore.setComplianceOptions((String)level, (Map)options);
        jproj.setOptions(options);
    }

    public static void scheduleFullBuild(final IProject project) {
        final IWorkspace ws = ResourcesPlugin.getWorkspace();
        final String msg = NLS.bind((String)Resources.buildingMsg, (Object)project.getName());
        Job buildJob = new Job(msg){

            public IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(msg, 2);
                try {
                    try {
                        project.build(6, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        ws.build(10, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    catch (CoreException e) {
                        IStatus iStatus = e.getStatus();
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family == ResourcesPlugin.FAMILY_MANUAL_BUILD;
            }
        };
        buildJob.setRule(ws.getRuleFactory().buildRule());
        buildJob.schedule();
    }

    public static void resetClasspath(IProject project, IProjectFacetVersion oldver, IProjectFacetVersion newver) throws CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IClasspathEntry[] rawClasspath = javaProject.getRawClasspath();
        boolean changed = false;
        boolean hadJRE = false;
        int i = 0;
        while (i < rawClasspath.length) {
            if (rawClasspath[i].getEntryKind() == 5 && JavaRuntime.JRE_CONTAINER.equals(rawClasspath[i].getPath().segment(0))) {
                IClasspathEntry newEntry;
                hadJRE = true;
                IClasspathEntry oldEntry = rawClasspath[i];
                IPath path = CPE_PREFIX_FOR_EXEC_ENV.append(JavaFacetUtil.getCorrespondingExecutionEnvironment(newver));
                rawClasspath[i] = newEntry = JavaCore.newContainerEntry((IPath)path, (IAccessRule[])oldEntry.getAccessRules(), (IClasspathAttribute[])oldEntry.getExtraAttributes(), (boolean)oldEntry.isExported());
                changed = true;
            }
            ++i;
        }
        if (!hadJRE) {
            boolean insertedJRE = false;
            ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>(Arrays.asList(rawClasspath));
            int i2 = rawClasspath.length - 1;
            while (i2 >= 0) {
                if (rawClasspath[i2].getEntryKind() == 3) {
                    entries.add(i2, JavaCore.newContainerEntry((IPath)CPE_PREFIX_FOR_EXEC_ENV.append(JavaFacetUtil.getCorrespondingExecutionEnvironment(newver))));
                    insertedJRE = true;
                    break;
                }
                ++i2;
            }
            if (!insertedJRE) {
                entries.add(0, JavaCore.newContainerEntry((IPath)CPE_PREFIX_FOR_EXEC_ENV.append(JavaFacetUtil.getCorrespondingExecutionEnvironment(newver))));
            }
            rawClasspath = entries.toArray(new IClasspathEntry[entries.size()]);
        }
        if (changed || !hadJRE) {
            javaProject.setRawClasspath(rawClasspath, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static String getCorrespondingExecutionEnvironment(IProjectFacetVersion fv) {
        String res = FACET_VER_TO_EXEC_ENV.get(fv);
        if (res == null) {
            throw new IllegalArgumentException(fv.toString());
        }
        return res;
    }

    private static final class Resources
    extends NLS {
        public static String buildingMsg;

        static {
            Resources.initializeMessages((String)JavaFacetUtil.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

