/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.views;

import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.annotations.core.utils.SignatureUtils;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIPlugin;
import org.eclipse.swt.graphics.Image;

public class AnnotationsValuesColumnLabelProvider
extends ColumnLabelProvider {
    private TreeViewer annotationTreeViewer;
    private Image true_image;
    private Image false_image;

    public AnnotationsValuesColumnLabelProvider(TreeViewer annotationTreeViewer) {
        this.annotationTreeViewer = annotationTreeViewer;
        this.true_image = JAXWSUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jst.ws.jaxws.ui", (String)"icons/obj16/true.gif").createImage();
        this.false_image = JAXWSUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jst.ws.jaxws.ui", (String)"icons/obj16/false.gif").createImage();
    }

    public String getText(Object element) {
        if (element instanceof IMethod) {
            try {
                return this.getTextForMethod((IMethod)element);
            }
            catch (JavaModelException jme) {
                JAXWSUIPlugin.log(jme.getStatus());
            }
        }
        return "";
    }

    private String getTextForMethod(IMethod method) throws JavaModelException {
        IJavaElement javaElement;
        if (this.annotationTreeViewer.getInput() instanceof IJavaElement && (javaElement = (IJavaElement)this.annotationTreeViewer.getInput()).exists()) {
            return this.getTextForMethod(method, javaElement);
        }
        return "";
    }

    private String getTextForMethod(IMethod method, IJavaElement annotatedElement) throws JavaModelException {
        List annotations = AnnotationUtils.getAnnotations((IJavaElement)annotatedElement);
        for (Annotation annotation : annotations) {
            String annotationName = AnnotationUtils.getAnnotationName((Annotation)annotation);
            IType type = method.getDeclaringType();
            if ((type == null || !annotationName.equals(type.getElementName())) && !annotationName.equals(type.getFullyQualifiedName())) continue;
            if (annotation.isNormalAnnotation()) {
                NormalAnnotation normalAnnotation = (NormalAnnotation)annotation;
                List memberValuePairs = normalAnnotation.values();
                for (MemberValuePair memberValuePair : memberValuePairs) {
                    if (!memberValuePair.getName().getIdentifier().equals(method.getElementName())) continue;
                    return this.getTextForMethod(method, memberValuePair.getValue());
                }
                continue;
            }
            if (!annotation.isSingleMemberAnnotation()) continue;
            SingleMemberAnnotation singleMemberAnnotation = (SingleMemberAnnotation)annotation;
            return this.getTextForMethod(method, singleMemberAnnotation.getValue());
        }
        return "";
    }

    private String getTextForMethod(IMethod method, Expression expression) throws JavaModelException {
        String returnType = method.getReturnType();
        if (SignatureUtils.isString((String)returnType) || SignatureUtils.isClass((String)returnType)) {
            return expression.toString();
        }
        if (SignatureUtils.isEnum((IMethod)method)) {
            String enumValue = expression.toString();
            return enumValue.substring(enumValue.lastIndexOf(".") + 1);
        }
        if (SignatureUtils.isPrimitive((String)returnType) && (returnType.charAt(0) == 'B' || returnType.charAt(0) == 'S' || returnType.charAt(0) == 'I' || returnType.charAt(0) == 'J' || returnType.charAt(0) == 'F' || returnType.charAt(0) == 'D')) {
            return expression.toString();
        }
        if (SignatureUtils.isArray((String)returnType) && expression instanceof ArrayInitializer) {
            ArrayInitializer arrayInitializer = (ArrayInitializer)expression;
            if (arrayInitializer.expressions().size() > 0) {
                return "[]{...}";
            }
            return "[]{}";
        }
        return "";
    }

    public Image getImage(Object element) {
        try {
            if (element instanceof IType) {
                return this.getImageForClass((IType)element);
            }
            if (element instanceof IMethod) {
                return this.getImageForMethod((IMethod)element);
            }
        }
        catch (JavaModelException jme) {
            JAXWSUIPlugin.log(jme.getStatus());
        }
        return null;
    }

    private Image getImageForClass(IType type) throws JavaModelException {
        IJavaElement javaElement;
        if (this.annotationTreeViewer.getInput() instanceof IJavaElement && (javaElement = (IJavaElement)this.annotationTreeViewer.getInput()).exists()) {
            return this.getImageForClass(type, javaElement);
        }
        return null;
    }

    private Image getImageForClass(IType type, IJavaElement javaElement) throws JavaModelException {
        List annotations = AnnotationUtils.getAnnotations((IJavaElement)javaElement);
        for (Annotation annotation : annotations) {
            String annotationName = AnnotationUtils.getAnnotationName((Annotation)annotation);
            if (!annotationName.equals(type.getElementName()) && !annotationName.equals(type.getFullyQualifiedName())) continue;
            return this.true_image;
        }
        return this.false_image;
    }

    private Image getImageForMethod(IMethod method) throws JavaModelException {
        IJavaElement javaElement;
        if (SignatureUtils.isBoolean((String)method.getReturnType()) && this.annotationTreeViewer.getInput() instanceof IJavaElement && (javaElement = (IJavaElement)this.annotationTreeViewer.getInput()).exists()) {
            return this.getImageForMethod(method, javaElement);
        }
        return null;
    }

    private Image getImageForMethod(IMethod method, IJavaElement javaElement) throws JavaModelException {
        List annotations = AnnotationUtils.getAnnotations((IJavaElement)javaElement);
        for (Annotation annotation : annotations) {
            SingleMemberAnnotation singleMemberAnnotation;
            String annotationName = AnnotationUtils.getAnnotationName((Annotation)annotation);
            IType declaringType = method.getDeclaringType();
            if ((declaringType == null || !annotationName.equals(declaringType.getElementName())) && !annotationName.equals(declaringType.getFullyQualifiedName())) continue;
            if (annotation.isNormalAnnotation()) {
                NormalAnnotation normalAnnotation = (NormalAnnotation)annotation;
                List memberValuePairs = normalAnnotation.values();
                for (MemberValuePair memberValuePair : memberValuePairs) {
                    if (!memberValuePair.getName().getIdentifier().equals(method.getElementName()) || !(memberValuePair.getValue() instanceof BooleanLiteral) || !((BooleanLiteral)memberValuePair.getValue()).booleanValue()) continue;
                    return this.true_image;
                }
                continue;
            }
            if (!annotation.isSingleMemberAnnotation() || !((singleMemberAnnotation = (SingleMemberAnnotation)annotation).getValue() instanceof BooleanLiteral) || !((BooleanLiteral)singleMemberAnnotation.getValue()).booleanValue()) continue;
            return this.true_image;
        }
        return this.false_image;
    }

    public void dispose() {
        super.dispose();
        this.true_image.dispose();
        this.false_image.dispose();
    }
}

