/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.ILaunchDescriptorType;

public class ProjectLaunchDescriptor
extends PlatformObject
implements ILaunchDescriptor {
    private final ILaunchDescriptorType type;
    private final IProject project;

    public ProjectLaunchDescriptor(ILaunchDescriptorType type, IProject project) {
        this.type = type;
        this.project = project;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IProject.class.equals(adapter)) {
            return adapter.cast(this.project);
        }
        return (T)super.getAdapter(adapter);
    }

    @Override
    public String getName() {
        return this.project.getName();
    }

    @Override
    public ILaunchDescriptorType getType() {
        return this.type;
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectLaunchDescriptor other = (ProjectLaunchDescriptor)obj;
        if (this.project == null ? other.project != null : !this.project.equals((Object)other.project)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

