/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.internal.commands;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.launch.ILaunchConfigurationTargetedDelegate;
import org.eclipse.launchbar.ui.internal.Activator;
import org.eclipse.launchbar.ui.internal.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BuildAction;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.progress.UIJob;

public class BuildActiveCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            ILaunchBarManager launchBarManager = Activator.getService(ILaunchBarManager.class);
            final ILaunchConfiguration config = launchBarManager.getActiveLaunchConfiguration();
            final ILaunchMode launchMode = launchBarManager.getActiveLaunchMode();
            final ILaunchTarget target = launchBarManager.getActiveLaunchTarget();
            new UIJob(Display.getDefault(), Messages.BuildActiveCommandHandler_0){

                public boolean belongsTo(Object family) {
                    return ResourcesPlugin.FAMILY_MANUAL_BUILD.equals(family);
                }

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    final Collection<IProject> projects = BuildActiveCommandHandler.this.getProjects(config);
                    if (BuildAction.isSaveAllSet()) {
                        BuildActiveCommandHandler.this.saveEditors(projects);
                    }
                    new Job(Messages.BuildActiveCommandHandler_1){

                        public boolean belongsTo(Object family) {
                            return ResourcesPlugin.FAMILY_MANUAL_BUILD.equals(family);
                        }

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                ILaunchConfigurationTargetedDelegate configDel2;
                                ILaunchConfigurationDelegate configDel;
                                if (config == null) {
                                    ResourcesPlugin.getWorkspace().build(10, monitor);
                                    return Status.OK_STATUS;
                                }
                                String mode = launchMode != null ? launchMode.getIdentifier() : "run";
                                HashSet<String> modes = new HashSet<String>();
                                modes.add(mode);
                                ILaunchDelegate delegate = config.getType().getPreferredDelegate(modes);
                                if (delegate == null) {
                                    delegate = config.getType().getDelegates(modes)[0];
                                }
                                if ((configDel = delegate.getDelegate()) instanceof ILaunchConfigurationTargetedDelegate) {
                                    configDel2 = (ILaunchConfigurationTargetedDelegate)configDel;
                                    boolean ret = configDel2.preLaunchCheck(config, mode, target, monitor);
                                    if (!ret) {
                                        return Status.CANCEL_STATUS;
                                    }
                                    if (!configDel2.buildForLaunch(config, mode, target, monitor)) {
                                        return Status.OK_STATUS;
                                    }
                                } else if (configDel instanceof ILaunchConfigurationDelegate2) {
                                    configDel2 = (ILaunchConfigurationDelegate2)configDel;
                                    boolean ret = configDel2.preLaunchCheck(config, mode, monitor);
                                    if (!ret) {
                                        return Status.CANCEL_STATUS;
                                    }
                                    if (!configDel2.buildForLaunch(config, mode, monitor)) {
                                        return Status.OK_STATUS;
                                    }
                                }
                                if (projects.isEmpty()) {
                                    ResourcesPlugin.getWorkspace().build(10, monitor);
                                } else {
                                    Collection<IBuildConfiguration> buildConfigs = BuildActiveCommandHandler.this.getBuildConfigs(projects);
                                    ResourcesPlugin.getWorkspace().build(buildConfigs.toArray(new IBuildConfiguration[buildConfigs.size()]), 10, true, monitor);
                                }
                                return Status.OK_STATUS;
                            }
                            catch (CoreException e) {
                                return e.getStatus();
                            }
                        }
                    }.schedule();
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    protected Collection<IProject> getProjects(ILaunchConfiguration config) {
        HashSet<IProject> projects = new HashSet<IProject>();
        if (config != null) {
            IResource[] mappedResources;
            try {
                mappedResources = config.getMappedResources();
            }
            catch (CoreException e) {
                return projects;
            }
            if (mappedResources != null) {
                IResource[] iResourceArray = mappedResources;
                int n = mappedResources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    IProject project = resource.getProject();
                    if (!projects.contains(project)) {
                        projects.add(project);
                        try {
                            projects.addAll(Arrays.asList(project.getReferencedProjects()));
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                    }
                    ++n2;
                }
            }
        }
        return projects;
    }

    protected Collection<IBuildConfiguration> getBuildConfigs(Collection<IProject> projects) {
        HashSet<IBuildConfiguration> configs = new HashSet<IBuildConfiguration>();
        for (IProject project : projects) {
            try {
                configs.add(project.getActiveBuildConfig());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return configs;
    }

    protected void saveEditors(Collection<IProject> projects) {
        Display.getDefault().syncExec(() -> {
            IWorkbenchWindow[] windows;
            IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchPage[] pages;
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
                int n3 = pages.length;
                int n4 = 0;
                while (n4 < n3) {
                    IWorkbenchPage page = iWorkbenchPageArray[n4];
                    if (projects.isEmpty()) {
                        page.saveAllEditors(false);
                    } else {
                        IEditorPart[] editors;
                        IEditorPart[] iEditorPartArray = editors = page.getDirtyEditors();
                        int n5 = editors.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IEditorPart editor = iEditorPartArray[n6];
                            IFile inputFile = ResourceUtil.getFile((IEditorInput)editor.getEditorInput());
                            if (inputFile != null && projects.contains(inputFile.getProject())) {
                                page.saveEditor(editor, false);
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        });
    }
}

