/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.knopflerfish;

import java.util.ArrayList;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.libra.framework.core.FrameworkInstanceConfiguration;
import org.eclipse.libra.framework.core.FrameworkInstanceDelegate;
import org.eclipse.libra.framework.core.OSGIFrameworkInstanceBehaviorDelegate;
import org.eclipse.libra.framework.core.TargetDefinitionUtil;
import org.eclipse.libra.framework.core.Trace;
import org.eclipse.libra.framework.knopflerfish.IKnopflerfishFrameworkInstance;
import org.eclipse.libra.framework.knopflerfish.IKnopflerfishVersionHandler;
import org.eclipse.libra.framework.knopflerfish.KnopflerfishFramework;
import org.eclipse.libra.framework.knopflerfish.Messages;
import org.eclipse.libra.framework.knopflerfish.internal.KnopflerfishFrameworkInstanceBehavior;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.NameVersionDescriptor;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;

public class KnopflerfishFrameworkInstance
extends FrameworkInstanceDelegate
implements IKnopflerfishFrameworkInstance {
    protected transient IKnopflerfishVersionHandler versionHandler;

    public IStatus canModifyModules(IModule[] add, IModule[] remove) {
        IStatus status = super.canModifyModules(add, remove);
        if (!status.isOK()) {
            return status;
        }
        if (this.getKnopflerfishVersionHandler() == null) {
            return new Status(4, "org.eclipse.libra.framework.knopflerfish", 0, Messages.errorNoRuntime, null);
        }
        if (add != null) {
            int size = add.length;
            int i = 0;
            while (i < size) {
                IModule module = add[i];
                IStatus status2 = this.getKnopflerfishVersionHandler().canAddModule(module);
                if (status2 != null && !status2.isOK()) {
                    return status2;
                }
                ++i;
            }
        }
        return Status.OK_STATUS;
    }

    public void setDefaults(IProgressMonitor monitor) {
        super.setDefaults(monitor);
        try {
            this.getKnopflerfishConfiguration();
        }
        catch (CoreException e) {
            Trace.trace((byte)2, (String)"Can't setup for Felix configuration.", (Throwable)e);
        }
    }

    public void importRuntimeConfiguration(IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        super.importRuntimeConfiguration(runtime, monitor);
        OSGIFrameworkInstanceBehaviorDelegate fsb = (OSGIFrameworkInstanceBehaviorDelegate)this.getServer().loadAdapter(KnopflerfishFrameworkInstanceBehavior.class, null);
        if (fsb != null) {
            IPath tempDir = fsb.getTempDirectory();
            if (!tempDir.isAbsolute()) {
                IPath rootPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
                tempDir = rootPath.append(tempDir);
            }
            this.setInstanceDirectory(tempDir.toPortableString());
        }
        try {
            this.getKnopflerfishConfiguration();
        }
        catch (CoreException e) {
            Trace.trace((byte)2, (String)"Can't setup for Felix configuration.", (Throwable)e);
        }
    }

    public KnopflerfishFramework getKnopflerfishRuntime() {
        if (this.getServer().getRuntime() == null) {
            return null;
        }
        return (KnopflerfishFramework)this.getServer().getRuntime().loadAdapter(KnopflerfishFramework.class, null);
    }

    public IKnopflerfishVersionHandler getKnopflerfishVersionHandler() {
        if (this.versionHandler == null) {
            if (this.getServer().getRuntime() == null || this.getKnopflerfishRuntime() == null) {
                return null;
            }
            this.versionHandler = this.getKnopflerfishRuntime().getVersionHandler();
        }
        return this.versionHandler;
    }

    public FrameworkInstanceConfiguration getKnopflerfishConfiguration() throws CoreException {
        return this.getFrameworkInstanceConfiguration();
    }

    public ITargetDefinition createDefaultTarget() throws CoreException {
        IPath installPath = this.getServer().getRuntime().getLocation();
        ITargetPlatformService service = TargetDefinitionUtil.getTargetPlatformService();
        ITargetDefinition targetDefinition = service.newTarget();
        targetDefinition.setName(this.getServer().getName());
        ITargetLocation[] containers = this.getDefaultBundleContainers(installPath);
        targetDefinition.setTargetLocations(containers);
        targetDefinition.resolve((IProgressMonitor)new NullProgressMonitor());
        TargetBundle[] targetBundles = targetDefinition.getAllBundles();
        ArrayList<NameVersionDescriptor> includedB = new ArrayList<NameVersionDescriptor>();
        TargetBundle[] targetBundleArray = targetBundles;
        int n = targetBundles.length;
        int n2 = 0;
        while (n2 < n) {
            TargetBundle b = targetBundleArray[n2];
            if (b.getStatus().getSeverity() == 0 && this.shouldInclude(b.getBundleInfo())) {
                if (b.getStatus().getCode() == 100) {
                    includedB.add(new NameVersionDescriptor(b.getBundleInfo().getSymbolicName(), null, "plugin"));
                } else {
                    includedB.add(new NameVersionDescriptor(b.getBundleInfo().getSymbolicName(), null));
                }
            }
            ++n2;
        }
        targetDefinition.setIncluded(includedB.toArray(new NameVersionDescriptor[includedB.size()]));
        service.saveTargetDefinition(targetDefinition);
        return targetDefinition;
    }

    private boolean shouldInclude(BundleInfo bundleInfo) {
        String[] bundles;
        String[] stringArray = bundles = new String[]{"log_api-3.0.5.jar", "console_api-3.0.1.jar", "cm_api-3.0.1.jar", "log-3.0.5.jar", "console-3.0.1.jar", "consoletty-3.0.1.jar", "frameworkcommands-3.0.3.jar", "logcommands-3.0.1.jar", "useradmin_api-3.0.1.jar"};
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            String bundleName = stringArray[n2];
            if (bundleInfo.getLocation().toString().indexOf(bundleName) > 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private ITargetLocation[] getDefaultBundleContainers(IPath installPath) {
        ITargetLocation[] containers = new ITargetLocation[8];
        ITargetPlatformService service = TargetDefinitionUtil.getTargetPlatformService();
        containers[0] = service.newDirectoryLocation(installPath.append("osgi").makeAbsolute().toPortableString());
        containers[1] = service.newDirectoryLocation(installPath.append("osgi").append("jars").append("log").makeAbsolute().toPortableString());
        containers[2] = service.newDirectoryLocation(installPath.append("osgi").append("jars").append("console").makeAbsolute().toPortableString());
        containers[3] = service.newDirectoryLocation(installPath.append("osgi").append("jars").append("cm").makeAbsolute().toPortableString());
        containers[4] = service.newDirectoryLocation(installPath.append("osgi").append("jars").append("consoletty").makeAbsolute().toPortableString());
        containers[5] = service.newDirectoryLocation(installPath.append("osgi").append("jars").append("frameworkcommands").makeAbsolute().toPortableString());
        containers[6] = service.newDirectoryLocation(installPath.append("osgi").append("jars").append("logcommands").makeAbsolute().toPortableString());
        containers[7] = service.newDirectoryLocation(installPath.append("osgi").append("jars").append("useradmin").makeAbsolute().toPortableString());
        return containers;
    }
}

