/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.breakpoints;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.lsp4e.debug.breakpoints.DSPLineBreakpoint;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class DSPBreakpointAdapter
implements IToggleBreakpointsTarget {
    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        IResource resource;
        ITextEditor textEditor = this.getEditor(part);
        if (textEditor != null && (resource = (IResource)textEditor.getEditorInput().getAdapter(IResource.class)) != null) {
            ITextSelection textSelection = (ITextSelection)selection;
            int lineNumber = textSelection.getStartLine();
            IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.lsp4e.debug.model");
            int i = 0;
            while (i < breakpoints.length) {
                IBreakpoint breakpoint = breakpoints[i];
                if (breakpoint instanceof ILineBreakpoint && resource.equals((Object)breakpoint.getMarker().getResource()) && ((ILineBreakpoint)breakpoint).getLineNumber() == lineNumber + 1) {
                    breakpoint.delete();
                    return;
                }
                ++i;
            }
            DSPLineBreakpoint lineBreakpoint = new DSPLineBreakpoint(resource, lineNumber + 1);
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)lineBreakpoint);
        }
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return true;
    }

    private ITextEditor getEditor(IWorkbenchPart part) {
        if (part instanceof ITextEditor) {
            return (ITextEditor)part;
        }
        return null;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }
}

