/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.internal.M2EUtils;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.ui.internal.util.ParentHierarchyEntry;

public class ParentGatherer {
    final IMavenProjectFacade projectFacade;

    public ParentGatherer(IMavenProjectFacade facade) {
        this.projectFacade = facade;
    }

    public List<ParentHierarchyEntry> getParentHierarchy(IProgressMonitor monitor) throws CoreException {
        ArrayList<ParentHierarchyEntry> hierarchy = new ArrayList<ParentHierarchyEntry>();
        IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
        IMaven maven = MavenPlugin.getMaven();
        MavenProject mavenProject = this.projectFacade.getMavenProject(monitor);
        hierarchy.add(new ParentHierarchyEntry(mavenProject, this.projectFacade));
        projectManager.execute(this.projectFacade, (context, monitor1) -> {
            MavenProject project = mavenProject;
            while (project.getModel().getParent() != null) {
                if (monitor1.isCanceled()) {
                    return null;
                }
                IFile resource = M2EUtils.getPomFile((MavenProject)(project = maven.resolveParentProject(project, monitor1)));
                IMavenProjectFacade facade = resource != null ? MavenPlugin.getMavenProjectRegistry().getProject(resource.getProject()) : null;
                hierarchy.add(new ParentHierarchyEntry(project, facade));
            }
            return null;
        }, monitor);
        return hierarchy;
    }
}

