/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.maven.model.Model;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.WorkingSets;
import org.eclipse.m2e.core.ui.internal.actions.SelectionUtil;
import org.eclipse.m2e.core.ui.internal.components.WorkingSetGroup;
import org.eclipse.m2e.core.ui.internal.wizards.AbstractMavenWizardPage;
import org.eclipse.m2e.core.ui.internal.wizards.MavenProjectSelectionDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenModuleWizardParentPage
extends AbstractMavenWizardPage {
    private static final Logger log = LoggerFactory.getLogger(MavenModuleWizardParentPage.class);
    private Combo moduleNameCombo;
    protected Text parentProjectText;
    private Button simpleProject;
    protected Object parentObject;
    private IContainer parentContainer;
    private IFile pom;
    private Model parentModel;
    private WorkingSetGroup workingSetGroup;
    private final List<IWorkingSet> workingSets;

    public MavenModuleWizardParentPage(ProjectImportConfiguration projectImportConfiguration, List<IWorkingSet> workingSets) {
        super("MavenModuleWizardParentPage", projectImportConfiguration);
        this.workingSets = workingSets;
        this.setTitle(Messages.wizardModulePageParentTitle);
        this.setDescription(Messages.wizardModulePageParentDescription);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        this.simpleProject = new Button(container, 32);
        this.simpleProject.setText(Messages.wizardProjectPageProjectSimpleProject);
        this.simpleProject.setData("name", (Object)"simpleProjectButton");
        this.simpleProject.setLayoutData((Object)new GridData(4, 128, false, false, 3, 1));
        this.simpleProject.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.validate()));
        Label nameLabel = new Label(container, 0);
        GridData gd_nameLabel = new GridData();
        gd_nameLabel.verticalIndent = 10;
        nameLabel.setLayoutData((Object)gd_nameLabel);
        nameLabel.setText(Messages.wizardModulePageParentModuleName);
        this.moduleNameCombo = new Combo(container, 2048);
        GridData gd_moduleNameCombo = new GridData(4, 128, true, false, 2, 1);
        gd_moduleNameCombo.verticalIndent = 10;
        this.moduleNameCombo.setLayoutData((Object)gd_moduleNameCombo);
        this.moduleNameCombo.addModifyListener(e -> this.validate());
        this.addFieldWithHistory("moduleName", this.moduleNameCombo);
        Label parentLabel = new Label(container, 0);
        parentLabel.setText(Messages.wizardModulePageParentParentProject);
        this.parentProjectText = new Text(container, 2048);
        this.parentProjectText.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.parentProjectText.setEditable(false);
        Button browseButton = new Button(container, 0);
        browseButton.setText(Messages.wizardModulePageParentBrowse);
        browseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            MavenProjectSelectionDialog dialog = new MavenProjectSelectionDialog(this.getShell());
            if (dialog.open() == 0) {
                this.setParent(dialog.getFirstResult());
                this.validate();
            }
        }));
        this.workingSetGroup = new WorkingSetGroup(container, this.workingSets, this.getShell());
        this.createAdvancedSettings(container, new GridData(4, 128, true, false, 3, 1));
        this.initialize();
        this.setControl((Control)container);
    }

    private void initialize() {
        this.loadParent();
        this.validate();
    }

    void validate() {
        String moduleName = this.moduleNameCombo.getText().trim();
        if (moduleName.length() == 0) {
            this.setErrorMessage(null);
            this.setMessage(Messages.wizardModulePageParentValidatorModuleName);
            this.setPageComplete(false);
            return;
        }
        IStatus nameStatus = ResourcesPlugin.getWorkspace().validateName(moduleName, 4);
        if (!nameStatus.isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            this.setPageComplete(false);
            return;
        }
        if (this.parentContainer != null && this.parentContainer.exists((IPath)new Path(moduleName))) {
            this.setErrorMessage(Messages.wizardModulePageParentValidatorNameExists);
            this.setPageComplete(false);
            return;
        }
        if (this.pom == null) {
            this.setErrorMessage(null);
            this.setMessage(Messages.wizardModulePageParentValidatorParentProject);
            this.setPageComplete(false);
            return;
        }
        if (!this.validateParent()) {
            return;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setPageComplete(true);
    }

    public void setParent(Object parent) {
        this.parentObject = parent;
        this.loadParent();
    }

    protected void loadParent() {
        Object project;
        if (this.parentObject == null) {
            return;
        }
        int type = SelectionUtil.getElementType(this.parentObject);
        if (4 == type) {
            this.pom = SelectionUtil.getType(this.parentObject, IFile.class);
        } else if (1 == type) {
            project = SelectionUtil.getType(this.parentObject, IProject.class);
            this.pom = project.getFile("pom.xml");
            this.workingSetGroup.selectWorkingSets(WorkingSets.getAssignedWorkingSets((IResource)project));
        } else if (this.parentObject instanceof IContainer) {
            this.pom = ((IContainer)this.parentObject).getFile((IPath)new Path("pom.xml"));
        }
        if (this.pom != null && this.pom.exists()) {
            this.parentObject = this.pom;
            this.parentContainer = this.pom.getParent();
            try {
                project = null;
                Object var3_5 = null;
                try (InputStream pomStream = this.pom.getContents();){
                    this.parentModel = MavenPlugin.getMavenModelManager().readMavenModel(pomStream);
                    this.validateParent();
                    this.parentProjectText.setText(this.parentModel.getArtifactId());
                }
                catch (Throwable throwable) {
                    if (project == null) {
                        project = throwable;
                    } else if (project != throwable) {
                        ((Throwable)project).addSuppressed(throwable);
                    }
                    throw project;
                }
            }
            catch (IOException | CoreException e) {
                log.error("Error loading POM: " + e.getMessage(), e);
            }
        }
    }

    private boolean validateParent() {
        if (this.parentModel != null && !"pom".equals(this.parentModel.getPackaging())) {
            this.setMessage(null);
            this.setErrorMessage(Messages.MavenModuleWizardParentPage_error);
            this.setPageComplete(false);
            return false;
        }
        return true;
    }

    public boolean isSimpleProject() {
        return this.simpleProject.getSelection();
    }

    public IWizardPage getNextPage() {
        return this.getWizard().getPage(this.isSimpleProject() ? "MavenProjectWizardArtifactPage" : "MavenProjectWizardArchetypePage");
    }

    public String getModuleName() {
        return this.moduleNameCombo.getText();
    }

    public Model getParentModel() {
        return this.parentModel;
    }

    public IFile getPom() {
        return this.pom;
    }

    public IContainer getParentContainer() {
        return this.parentContainer;
    }

    public void addModuleNameListener(ModifyListener modifyListener) {
        this.moduleNameCombo.addModifyListener(modifyListener);
    }

    public void removesModuleNameListener(ModifyListener modifyListener) {
        this.moduleNameCombo.removeModifyListener(modifyListener);
    }

    public void addParentProjectListener(ModifyListener modifyListener) {
        this.parentProjectText.addModifyListener(modifyListener);
    }

    public void removesParentProjectListener(ModifyListener modifyListener) {
        this.parentProjectText.removeModifyListener(modifyListener);
    }

    public void addArchetypeSelectionListener(SelectionListener selectionListener) {
        this.simpleProject.addSelectionListener(selectionListener);
    }

    public void removeArchetypeSelectionListener(SelectionListener selectionListener) {
        this.simpleProject.removeSelectionListener(selectionListener);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.workingSetGroup.dispose();
    }
}

